% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesize.R
\name{confint.hypothesis_test}
\alias{confint.hypothesis_test}
\alias{confint.wald_test}
\alias{confint.z_test}
\title{Confidence Interval from Hypothesis Test (Duality)}
\usage{
\method{confint}{hypothesis_test}(object, parm = NULL, level = 0.95, ...)

\method{confint}{wald_test}(object, parm = NULL, level = 0.95, ...)

\method{confint}{z_test}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{A \code{hypothesis_test} object.}

\item{parm}{Ignored (for compatibility with generic).}

\item{level}{Numeric. Confidence level (default 0.95).}

\item{...}{Additional arguments (ignored).}
}
\value{
A named numeric vector with elements \code{lower} and \code{upper}.
}
\description{
Extracts a confidence interval from a hypothesis test object, exploiting
the fundamental duality between hypothesis tests and confidence intervals.
}
\details{
Hypothesis tests and confidence intervals are two views of the same
underlying inference. For a test of \eqn{H_0: \theta = \theta_0} at level
\eqn{\alpha}, the \eqn{(1-\alpha)} confidence interval contains exactly
those values of \eqn{\theta_0} that would \strong{not} be rejected.

This duality means:
\itemize{
\item A 95\% CI contains all values where the two-sided test has p > 0.05
\item The CI boundary is where p = 0.05 exactly
\item Inverting a test "inverts" it into a confidence set
}
}
\section{Available Methods}{

Confidence intervals are currently implemented for:
\itemize{
\item \code{wald_test}: Uses \eqn{\hat{\theta} \pm z_{\alpha/2} \cdot SE}
\item \code{z_test}: Uses \eqn{\bar{x} \pm z_{\alpha/2} \cdot \sigma/\sqrt{n}}
}

Tests without stored estimates (like \code{lrt} or \code{fisher_combined_test})
cannot produce confidence intervals directly.
}

\examples{
# Wald test stores estimate and SE, so CI is available
w <- wald_test(estimate = 2.5, se = 0.8)
confint(w)              # 95\% CI
confint(w, level = 0.99) # 99\% CI

# The duality: 2.5 is in the CI, and testing H0: theta = 2.5
# would give p = 1 (not rejected)
wald_test(estimate = 2.5, se = 0.8, null_value = 2.5)

# z-test also supports confint
z <- z_test(rnorm(50, mean = 10, sd = 2), mu0 = 9, sigma = 2)
confint(z)

}
