% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_intervals.R
\name{form_class_intervals}
\alias{form_class_intervals}
\title{Form Class Intervals}
\usage{
form_class_intervals(
  data,
  variable,
  method = c("equal", "width", "count", "manual"),
  n_intervals = 4L,
  interval_width,
  format = "(a,b]",
  range = NULL,
  format_lowest = ifelse(isinteger, "< a", "<= a"),
  format_highest = "> b",
  break_points = NULL,
  name = sprintf("\%s.f", variable)
)
}
\arguments{
\item{data}{A dataset or a survey object.}

\item{variable}{The name of the numeric variable to convert into intervals.}

\item{method}{The method used to create intervals:
\itemize{
\item 'equal' for equal-width intervals,
\item 'width' for intervals of a specific width,
\item 'count' for equal-count intervals, and
\item 'manual' to specify break points manually.
}}

\item{n_intervals}{For methods 'equal' and 'count', this specifies the
number of intervals to create.}

\item{interval_width}{For method 'width', this sets the width of the
intervals.}

\item{format}{The format for interval labels; use 'a' and 'b' to represent
the min/max of each interval, respectively.}

\item{range}{The range of the data; use this to adjust the labels
(e.g., for continuous data, set this to the floor/ceiling
of the min/max of the data to get prettier intervals).
If range does not cover the range of the data, values outside will be
placed into 'less than a' and 'greater than b' categories.}

\item{format_lowest}{Label format for values lower than the min of range.}

\item{format_highest}{Label format for values higher than the max of range.}

\item{break_points}{For method 'manual', specify breakpoints here as a
numeric vector.}

\item{name}{The name of the new variable in the resulting data set.}
}
\value{
A dataframe with an additional column containing categorical class
intervals.
}
\description{
This function creates categorical intervals from a numeric variable in the given dataset.
}
\examples{
form_class_intervals(iris, "Sepal.Length", "equal", 5L)
}
\author{
Tom Elliott, Zhaoming Su
}
