% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rewardestimation.R
\name{get_estimation_densities}
\alias{get_estimation_densities}
\title{Return the total kernel density surrounding each treatment candidate for the
propensity/outcome estimation problems in a fitted learner.}
\usage{
get_estimation_densities(lnr, ...)
}
\arguments{
\item{lnr}{The learner from which to extract densities}

\item{...}{Refer to the Julia documentation for other parameters}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.2.2/RewardEstimation/reference/#IAI.get_estimation_densities}{\code{IAI.get_estimation_densities}}
}
\section{IAI Compatibility}{

Requires IAI version 2.2 or higher.
}

\examples{
\dontrun{iai::get_estimation_densities(lnr, ...)}

}
