sim_data<-function(n,k,m,G,R,opt.rep=1){
  
  nt<-length(diag(G))
  b<-MASS::mvrnorm(n = n, mu=m, Sigma=G)
  
  if (opt.rep==1) nr<-matrix(rep(k,n*nt),ncol=nt)
  if (opt.rep==2) nr<-matrix(rpois(n*nt,k)+1,ncol=nt)
  
  y<-NULL
  ind<-NULL
  type<-NULL
  
  for (i in 1:nt){
    br<-matrix(rep(b[,i],times=nr[,i]),ncol=1)
    aux_y<-br+rnorm(length(br),0,sqrt(R[i,i]))
    aux_id<-rep(1:n,times=nr[,i])
    aux_type<-rep(i,length(aux_id))
    y<-c(y,aux_y)
    ind<-c(ind,aux_id)
    type<-c(type,aux_type)
  }
  ind<-factor(ind)
  type<-factor(type)
  return(data.frame(y=y,ind=ind,type=type))
  
}
