% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGraph.R
\name{getStandardAssessmentGraphs}
\alias{getStandardAssessmentGraphs}
\alias{getLandingsGraph}
\alias{getRecruitmentGraph}
\alias{getFishingMortalityGraph}
\alias{getSpawningStockBiomassGraph}
\alias{getFishMortality}
\alias{getstock_recruitment}
\alias{getYSSB}
\alias{getSSBHistoricalPerformance}
\alias{getFishingMortalityHistoricalPerformance}
\alias{getRecruitmentHistoricalPerformance}
\alias{getStockStatusTable}
\title{Get a Graph of Stock Assessment Output}
\usage{
getLandingsGraph(assessmentKey, ...)

getRecruitmentGraph(assessmentKey, ...)

getFishingMortalityGraph(assessmentKey, ...)

getSpawningStockBiomassGraph(assessmentKey, ...)

getFishMortality(assessmentKey, ...)

getstock_recruitment(assessmentKey, ...)

getYSSB(assessmentKey, ...)

getSSBHistoricalPerformance(assessmentKey, ...)

getFishingMortalityHistoricalPerformance(assessmentKey, ...)

getRecruitmentHistoricalPerformance(assessmentKey, ...)

getStockStatusTable(assessmentKey, ...)
}
\arguments{
\item{assessmentKey}{the unique identifier of the stock assessment}

\item{...}{to allow scope for back compatibility}
}
\value{
An array representing a bitmap.
}
\description{
Get a graph of stock assessment output, e.g., historical stock size,
recruitment, and fishing pressure.
}
\examples{
\dontrun{
assessmentKeys <- findAssessmentKey("had", 2015)
landings_img <- getLandingsGraph(assessmentKeys[1])
landings_img

landings_plots <- getLandingsGraph(assessmentKeys)
landings_plots
}

}
\seealso{
\code{\link{getListStocks}} gets a list of stocks.

\code{\link{getFishStockReferencePoints}} gets biological reference points.

\code{\link{icesSAG-package}} gives an overview of the package.
}
