% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CHAMP.R
\name{CHAMP}
\alias{CHAMP}
\title{Find the Convex Hull of Admissible Modularity Partitions (\code{CHAMP})}
\usage{
CHAMP(network, partitions, plottitle = NULL)
}
\arguments{
\item{network}{The network, as igraph object, to be clustered into communities. Only undirected networks are currently supported. If the object has a 'weight' edge attribute, then that attribute will be used.}

\item{partitions}{A list of unique partitions (in the format generated by \code{get_partitions}).}

\item{plottitle}{Optional title for generated plot of (generalized) modularity versus resolution parameter.}
}
\value{
\code{CHAMP} returns the input list of partitions with a \code{$CHAMPsummary} about which partitions are somewhere optimal (in the sense of modularity Q with a resolution parameter gamma) and their domains of optimality, along with the generated \code{$CHAMPfigure} plot of the upper envelope of Q(gamma). The returned list object also contains the original list entered into the \code{partitions} argument.
}
\description{
The Convex Hull of Admissible Modularity Partitions (\code{CHAMP}) method post-processes an input set of partitions as collected by \code{get_partitions} (or as formatted similarly from some other source of selected partitions) to identify the partitions that are somewhere optimal in the resolution parameter and the associated domains of (generalized) modularity optimization. That is, given the input set of partitions of nodes in a network into communities, \code{CHAMP} identifies which input partition is optimal at each value of the resolution parameter, gamma. Importantly, \code{CHAMP} is deterministic and polynomial in time given a specified input set of partitions; that is, all of the computational complexity and pseudo-stochastic heuristic nature of community detection is in identifying a good input set in \cite{get_partitions}.

The \code{CHAMP} method was developed and studied in Weir, William H., Scott Emmons, Ryan Gibson, Dane Taylor, and Peter J. Mucha. “Post-Processing Partitions to Identify Domains of Modularity Optimization.” Algorithms 10, no. 3 (August 19, 2017): 93. \doi{10.3390/a10030093}.

See also \url{https://github.com/wweir827/CHAMP} and \url{https://github.com/ragibson/ModularityPruning}.
}
\examples{
# Use get_partitions and CHAMP to generate multiple partitions of the
# Zachary karate club and identify the domains of optimality in the
# resolution parameter for different partitions
data(karate, package = "igraphdata")
partitions <- get_partitions(karate, n_runs = 500)
partitions <- CHAMP(karate, partitions, plottitle = "Weighted Karate Club")
}
\author{
Peter J. Mucha (\email{peter.j.mucha@dartmouth.edu}), Alex Craig, Rachel Matthew, Sydney Rosenbaum and Ava Scharfstein
}
