% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_index.R
\name{h_index}
\alias{h_index}
\title{H-Index (\code{h_index})}
\usage{
h_index(ego_id, measure, prefix = NULL, suffix = NULL)
}
\arguments{
\item{ego_id}{A vector of ego identifiers located in an alter dataframe. If using data objects created by \code{\link{ego_netwrite}}, this should be the data frame entitled \code{alters}.}

\item{measure}{A vector of alter attributes for a given categorical measure.}

\item{prefix}{A character value indicating the desired prefix for the calculated homophily measure.}

\item{suffix}{A character value indicating the desired suffix for the calculated homophily measure.}
}
\value{
\code{h_index} returns a dataframe of vectors that include the ego identifier and h-index of diversity for the desired categorical attribute.
}
\description{
Measure of ego network diversity for categorical attributes (Perry et al. 2018)
}
\examples{

# Run `ego_netwrite`
ngq_nw <- ego_netwrite(egos = ngq_egos,
                      ego_id = ngq_egos$ego_id,

                      alters = ngq_alters,
                      alter_id = ngq_alters$alter_id,
                      alter_ego = ngq_alters$ego_id,

                      max_alters = 10,
                      alter_alter = ngq_aa,
                      aa_ego = ngq_aa$ego_id,
                      i_elements = ngq_aa$alter1,
                      j_elements = ngq_aa$alter2,
                      directed = FALSE)


# Get H-index for race
race_hindex <- h_index(ego_id = ngq_nw$alters$ego_id,
                      measure = ngq_nw$alters$race,
                      prefix = "race")

race_hindex
}
