% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{asq_ord_bool}
\alias{asq_ord_bool}
\title{Is the mediation effect significant?}
\usage{
asq_ord_bool(alpha, u1, u2, u3, numSquares = 4L, upLim = 0.5)
}
\arguments{
\item{alpha}{Significance level for the test.}

\item{u1, u2, u3}{The U values to be used in the test}

\item{numSquares}{The number of squares to be used in the asq-test. Always superceded by upLim}

\item{upLim}{The allowed extension, between 0 and 1, of the squares towards the center of the region}
}
\value{
A boolean variable indicating if the indirect effect null hypothesis is rejected.
}
\description{
This function takes 3 U values for the asq-test for 2 ordered
mediators, as well as an alpha level. It returns whether the
test would reject at the given alpha level. Additionally,
the cutoff, either specified by number of squares or the 
percentage towards the center of the transformation region, 
can be specified.
This function is primarily called by the asq_ord function
to determine if the test is significant at one of a chosen
set of alpha values.
}
\examples{
asq_ord_bool(.05, .02, .015, .995, upLim = .75)
}
