% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/im.plotRGB.R
\name{im.plotRGB}
\alias{im.plotRGB}
\title{Plot a Raster Image as an RGB Composite with User-Selected Bands}
\usage{
im.plotRGB(x, r, g, b, title = "")
}
\arguments{
\item{x}{A `SpatRaster` object representing the input multispectral image.}

\item{r}{An integer specifying the band index for the Red channel.}

\item{g}{An integer specifying the band index for the Green channel.}

\item{b}{An integer specifying the band index for the Blue channel.}

\item{title}{A character string specifying the plot title (default: "").}
}
\value{
This function does not return an object. It directly generates a plot.
}
\description{
This function visualizes a multispectral raster image using user-defined bands
for the Red, Green, and Blue channels. A linear contrast stretch is applied to enhance visualization.
}
\details{
- The function allows users to **manually select bands** for RGB visualization.
- It applies `stretch="lin"` in `plotRGB()` to enhance contrast.
- Axis and label colors are set to white for better contrast with dark backgrounds.
- The function supports displaying axes (`axes = TRUE`) and sets plot margins.
}
\examples{
library(terra)

# Create a 3-band raster
r <- rast(nrows = 10, ncols = 10, nlyrs = 3)
values(r) <- runif(ncell(r) * 3)

# Plot with user-selected bands (3 = Red, 2 = Green, 1 = Blue)
im.plotRGB(r, r = 3, g = 2, b = 1, title = "Custom RGB Visualization")
}
\seealso{
[im.plotRGB.auto()], [im.ggplot()]
}
