% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v0_germline.R
\name{repGermline}
\alias{repGermline}
\title{Creates germlines for clonal lineages}
\usage{
repGermline(.data, .species, .min_nuc_outside_cdr3, .threads)
}
\arguments{
\item{.data}{The data to be processed. Can be \link{data.frame}, \link[data.table:data.table]{data.table::data.table}
or a list of these objects.

It must have columns in the immunarch compatible format \link{immunarch_data_format}.}

\item{.species}{Species from which the data was acquired. Available options:
"HomoSapiens" (default), "MusMusculus", "BosTaurus", "CamelusDromedarius",
"CanisLupusFamiliaris", "DanioRerio", "MacacaMulatta", "MusMusculusDomesticus",
"MusMusculusCastaneus", "MusMusculusMolossinus", "MusMusculusMusculus", "MusSpretus",
"OncorhynchusMykiss", "OrnithorhynchusAnatinus", "OryctolagusCuniculus", "RattusNorvegicus",
"SusScrofa".}

\item{.min_nuc_outside_cdr3}{This parameter sets how many nucleotides should have V or J chain
outside of CDR3 to be considered good for further alignment.}

\item{.threads}{Number of threads to use.}
}
\value{
Data with added columns:
\itemize{
\item Sequence (FR1+CDR1+FR2+CDR2+FR3+CDR3+FR4 in nucleotides; the column will be replaced if exists)
\item V.allele, J.allele (chosen alleles of V and J genes),
\item V.aa, J.aa (V and J sequences from original clonotype, outside CDR3, converted to amino acids)
\item Germline.sequence (combined germline nucleotide sequence)
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function creates germlines for clonal lineages. B cell clonal lineage
represents a set of B cells that presumably have a common origin (arising from the same VDJ
rearrangement event) and a common ancestor. Each clonal lineage has its own germline sequence
that represents the ancestral sequence for each BCR in clonal lineage. In other words,
germline sequence is a sequence of B-cells immediately after VDJ recombination, before
B-cell maturation and hypermutation process. Germline sequence is useful for assessing
the degree of mutation and maturity of the repertoire.
}
\examples{

data(bcrdata)

bcrdata$data \%>\%
  top(5) \%>\%
  repGermline()
}
\concept{germline}
