% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_iterative.R
\name{impute_iterative}
\alias{impute_iterative}
\title{Iterative imputation}
\usage{
impute_iterative(
  ds,
  model_spec_parsnip = linear_reg(),
  model_fun_unsupervised = NULL,
  predict_fun_unsupervised = NULL,
  max_iter = 10,
  stop_fun = NULL,
  initial_imputation_fun = NULL,
  cols_used_for_imputation = "only_complete",
  cols_order = seq_len(ncol(ds)),
  rows_used_for_imputation = "only_complete",
  rows_order = seq_len(nrow(ds)),
  update_model = "every_iteration",
  update_ds_model = "every_iteration",
  stop_fun_args = NULL,
  M = is.na(ds),
  model_arg = NULL,
  warn_incomplete_imputation = TRUE,
  ...
)
}
\arguments{
\item{ds}{The data set to be imputed. Must be a data frame with column names.}

\item{model_spec_parsnip}{The model type used for supervised imputation (see
(\code{\link[=impute_supervised]{impute_supervised()}} for details).}

\item{model_fun_unsupervised}{An unsupervised model function (see
\code{\link[=impute_unsupervised]{impute_unsupervised()}} for details).}

\item{predict_fun_unsupervised}{A predict function for unsupervised
imputation (see \code{\link[=impute_unsupervised]{impute_unsupervised()}} for details).}

\item{max_iter}{Maximum number of iterations}

\item{stop_fun}{A stopping function (see details below) or \code{NULL}. If \code{NULL},
iterations are only stopped after \code{max_iter} is reached.}

\item{initial_imputation_fun}{This function will do the initial imputation of
the missing values. If \code{NULL}, no initial imputation is done. Some common
choices like mean imputation are implemented in the package missMethods.}

\item{cols_used_for_imputation}{Which columns should be used to impute other
columns? Possible choices: "only_complete", "already_imputed", "all"}

\item{cols_order}{Ordering of the columns for imputation. This can be a
vector with indices or an \code{order_option} from \code{\link[=order_cols]{order_cols()}}.}

\item{rows_used_for_imputation}{Which rows should be used to impute other
rows? Possible choices: "only_complete", "partly_complete",
"complete_in_k", "already_imputed", "all_except_i", "all"}

\item{rows_order}{Ordering of the rows for imputation. This can be a vector
with indices or an \code{order_option} from \code{\link[=order_rows]{order_rows()}}.}

\item{update_model}{How often should the model for imputation be updated?}

\item{update_ds_model}{How often should the data set for the inner model be
updated?}

\item{stop_fun_args}{Further arguments passed on to \code{stop_fun}.}

\item{M}{Missing data indicator matrix}

\item{model_arg}{Further arguments for \code{model_fun_unsupervised} (see
\code{\link[=impute_unsupervised]{impute_unsupervised()}} for details).}

\item{warn_incomplete_imputation}{Should a warning be given, if the
returned data set still contains \code{NA}?}

\item{...}{Further arguments passed on to \code{\link[stats:predict]{stats::predict()}} or
\code{predict_fun_unsupervised}.}
}
\value{
an imputed data set (or a return value of \code{stop_fun})
}
\description{
Iterative imputation of a data set
}
\details{
This function impute a data set in an iterative way. Internally, either
\code{\link[=impute_supervised]{impute_supervised()}} or \code{\link[=impute_unsupervised]{impute_unsupervised()}} is used, depending on the
values of \code{model_spec_parsnip}, \code{model_fun_unsupervised} and
\code{predict_fun_unsupervised}. If you want to use a supervised inner method,
\code{model_spec_parsnip} must be specified and \code{model_fun_unsupervised} and
\code{predict_fun_unsupervised} must both be \code{NULL}. For an unsupervised inner
method, \code{model_fun_unsupervised} and \code{predict_fun_unsupervised} must be
specified and \code{model_spec_parsnip} must be \code{NULL}. Some arguments of this
function are only meaningful for \code{\link[=impute_supervised]{impute_supervised()}} or
\code{\link[=impute_unsupervised]{impute_unsupervised()}}.
}
\section{stop_fun}{
 The \code{stop_fun} should take the arguments
\itemize{
\item \code{ds} (the data set imputed in the current iteration)
\item \code{ds_old} (the data set imputed in the last iteration)
\item a list (with named elements \code{M}, \code{nr_iterations}, \code{max_iter})
\item \code{stop_fun_args}
\item \code{res_stop_fun} (the return value of \code{stop_fun} from the last iteration.
Initial value for the first iteration: \code{list(stop_iter = FALSE)})
in this order.
}

To allow for a next iteration, the \code{stop_fun} must return a list which
contains the named element \code{stop_iter = FALSE}. The simple return
\code{list(stop_iter = FALSE)} will allow the iteration to continue. However,
the list can include more information which are handed over to \code{stop_fun}
in the next iteration. For example, the return value
\code{list(stop_iter = FALSE, last_eps = 0.3)} would also lead to another
iteration. If \code{stop_fun} does not return a list or the list does not
contain  \code{stop_iter = FALSE} the iteration is stopped and the return value
of \code{stop_fun} is returned as result of \code{impute_iterative()}. Therefore,
this return value should normally include the imputed data set \code{ds} or
\code{ds_old}.

An example for a \code{stop_fun} is \code{\link[=stop_ds_difference]{stop_ds_difference()}}.
}

\examples{
set.seed(123)
# simple example
ds_mis <- missMethods::delete_MCAR(
  data.frame(X = rnorm(20), Y = rnorm(20)), 0.2, 1
)
impute_iterative(ds_mis, max_iter = 2)
# using pre-imputation
ds_mis <- missMethods::delete_MCAR(
  data.frame(X = rnorm(20), Y = rnorm(20)), 0.2
)
impute_iterative(
  ds_mis,
  max_iter = 2, initial_imputation_fun = missMethods::impute_mean
)
# example using stop_ds_difference() as stop_fun
ds_mis <- missMethods::delete_MCAR(
  data.frame(X = rnorm(20), Y = rnorm(20)), 0.2
)
ds_imp <- impute_iterative(
  ds_mis,
  initial_imputation_fun = missMethods::impute_mean,
  stop_fun = stop_ds_difference, stop_fun_args = list(eps = 0.5)
)
attr(ds_imp, "nr_iterations")
}
\seealso{
\itemize{
\item \code{\link[=impute_supervised]{impute_supervised()}} and \code{\link[=impute_unsupervised]{impute_unsupervised()}} as the workhorses for
the imputation.
\item \code{\link[=stop_ds_difference]{stop_ds_difference()}} as an example of a stop function.
}
}
