#ifndef PENALTIES_HPP
#define PENALTIES_HPP

#define IS_PENALIZED(X) ((X) > 99 && (X) < 1000)
#include "l0norm.h"
#define PEN_L0NORM 100
#include "lasso.h"
#define PEN_LASSO 101
#include "ridge.h"
#define PEN_RIDGE 102
#include "raking.h"
#define PEN_RACK 103
#include "minentropy.h"
#define PEN_MINENT 104
#include "quadrat.h"
#define PEN_QUADRAT 105
#include "quadmod.h"
#define PEN_QUADMOD 106
#include "hellinger.h"
#define PEN_HELL 107

#include "mcp.h" //minimax concave penalty
#define PEN_MCP 108
#include "scad.h" //smoothly clipped absolute deviations
#define PEN_SCAD 109
#include "relasso.h" //relative lasso
#define PEN_RELASSO 110
#include "modrelasso.h" //modified relative lasso
#define PEN_MODRELASSO 111
#include "rehuber.h" //relative Huber
#define PEN_REHUBER 112
#include "modrehuber.h" //modified relative Huber
#define PEN_MODREHUBER 113
#endif // PENALTIES_HPP
