% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/null_default.R
\name{null-default}
\alias{null-default}
\alias{\%||\%}
\title{Default NULL operator}
\usage{
x \%||\% y
}
\arguments{
\item{x}{The left-hand side, the value(s) to be evaluated
as either NULL or not.}

\item{y}{The right-hand side, the value(s) to be returned
if \code{lhs} evaluates to NULL.}
}
\value{
An atomic value or vector the same length as the left-hand
side input.
}
\description{
This operator is seen in \code{{rlang}} and has been included
in base R since version 4.4.0. If the left-hand side
is NULL, it will automatically return the value of
the right-hand side. This is useful for programming
to ensure a function or process returns a non-null
default.
}
\examples{
{
  NULL \%||\% 'fizzbuzz' #returns fizzbuzz
  'test' \%||\% 'fizzbuzz'#returns 'test'
}


}
