% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapper_repeat.R
\name{bm_repeat_indexing}
\alias{bm_repeat_indexing}
\alias{bm_repeat_indexing_matrix}
\title{Re-indexing matrix for repeated mappers}
\usage{
bm_repeat_indexing(n_map, n_rep, interleaved = FALSE)

bm_repeat_indexing_matrix(n_map, n_rep)
}
\arguments{
\item{n_map}{The block mapper size}

\item{n_rep}{The number of times the block is repeated}

\item{interleaved}{logical; if \code{TRUE}, the state vector indexing is
interleaved. Default is \code{FALSE}, for blockwise indexing.}
}
\value{
\code{bm_repeat_indexing}: Returns a list with a vector of offsets,
\code{offsets}, and a vector of relative index values, \code{index}; block \code{k}
indexing is given by \code{offsets[k] + index}.

\code{bm_repeat_indexing_matrix}: A \code{sparseMatrix} object.
}
\description{
Helper methods for regular and interleaved state vector
indexing, meant for use in \link{bm_repeat} mappers.
}
\section{Functions}{
\itemize{
\item \code{bm_repeat_indexing()}: Construct the offsets and within-block
index vectors for a repeated mapper, with or without interleaving.

\item \code{bm_repeat_indexing_matrix()}: Creates a sparse matrix \code{A} such that
\code{z <- A \%*\% x} constructs a blockwise version \code{z = c(x1, x2, ..., xn)} of
an interleaved state vector \code{x = c(x1[1], x2[1], ..., x1[2], x2[2], ...)}.
Each block is of size \code{n_map}, and there are \code{n_rep} blocks. The reverse
operation, taking a blockwise \code{z = c(x1, x2, ..., xn)} to an interleaved
vector is \code{x <- Matrix::t(A) \%*\% z}.

}}
\examples{
(idx <- bm_repeat_indexing(3, 2, FALSE))
(idx <- bm_repeat_indexing(3, 2, TRUE))
(A <- bm_repeat_indexing_matrix(3, 2))
(x_interleaved <- 1:6)
(x_blockwise <- as.vector(A \%*\% x_interleaved))
(x_recovered <- as.vector(Matrix::t(A) \%*\% x_blockwise))

}
\keyword{internal}
