% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{bru_comp_eval}
\alias{bru_comp_eval}
\alias{bru_component_eval}
\title{Evaluate component values in predictor expressions}
\usage{
bru_comp_eval(
  main,
  group = NULL,
  replicate = NULL,
  weights = NULL,
  .state = NULL
)
}
\arguments{
\item{main, group, replicate, weights}{Specification of where to evaluate a
component. The four inputs are passed on to the joint \code{bru_mapper} for the
component, as

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(mapper = list(
       main = main,
       group = group,
       replicate = replicate),
     scale = weights)
}\if{html}{\out{</div>}}

NOTE: If you have model component with the same name as a data variable you
want to supply as input to \code{name_eval()}, you need to use
\code{.data.[["myvar"]]} to access it. Otherwise, it will try to use the other
component effect as input, which is ill-defined.}

\item{.state}{The internal component state. Normally supplied automatically
by the internal methods for evaluating inlabru predictor expressions.}
}
\value{
A vector of values for a component
}
\description{
In predictor expressions, \code{name_eval(...)} can be used to evaluate
the effect of a component called "name".
}
\examples{
if (bru_safe_inla() &&
  require("sf", quietly = TRUE) &&
  requireNamespace("sn", quietly = TRUE)) {
  mesh <- fmesher::fm_mesh_2d_inla(
    cbind(0, 0),
    offset = 2,
    max.edge = 2.5
  )
  spde <- INLA::inla.spde2.pcmatern(
    mesh,
    prior.range = c(1, NA),
    prior.sigma = c(0.2, NA)
  )
  set.seed(12345L)
  data <- sf::st_as_sf(
    data.frame(
      x = runif(50),
      y = runif(50),
      z = rnorm(50)
    ),
    coords = c("x", "y")
  )
  fit <- bru(
    z ~ -1 + field(geometry, model = spde),
    family = "gaussian", data = data,
    options = list(control.inla = list(int.strategy = "eb"))
  )
  pred <- generate(
    fit,
    newdata = data.frame(A = 0.5, B = 0.5),
    formula = ~ field_eval(cbind(A, B)),
    n.samples = 1L
  )
}
}
