% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_inlpal_class.R
\name{make_inlpal_class}
\alias{make_inlpal_class}
\title{Construct an inlpal-class object}
\usage{
make_inlpal_class(x, call, nan = NA_character_)
}
\arguments{
\item{x}{'character' vector.
Palette colors represented in hexadecimal format.}

\item{call}{'call'-class object.
Unevaluated function call (expression) that can be used to reproduce the color palette.}

\item{nan}{'character' string.
Color meant for missing data, in hexadecimal format,
where \code{NA} indicates no color is specified.}
}
\value{
An object of class 'inlpal' that inherits behavior from the 'character' class.
The returned object is comprised of a 'character'
vector of \code{n} colors in the RGB color system.
Colors are specified with a string of the form \code{"#RRGGBB"} or \code{"#RRGGBBAA"},
where \code{RR}, \code{GG}, \code{BB}, and \code{AA} are the
red, green, blue, and alpha hexadecimal values (00 to FF), respectively.
Attributes of the returned object include:
\code{"names"} is an the informal names assigned to colors in the palette,
where \code{NULL} indicates no color names are specified;
\code{"nan"} is a character string giving the color meant for missing data,
in hexadecimal format, where \code{NA} indicates no color is specified; and
\code{"call"} is an object of class '\link{call}' giving the unevaluated function
call (expression) that can be used to reproduce the color palette.
Use the \code{\link{eval}} function to evaluate the \code{"call"} argument.
A simple \code{\link[=plot.inlpal]{plot}} method is provided for the 'inlpal' class.
}
\description{
A constructor for the 'inlpal' class.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{internal}
