% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_property.R
\name{validate_property}
\alias{validate_property}
\title{Validate a property against a given type or validation function}
\usage{
validate_property(name, value, validator)
}
\arguments{
\item{name}{The name of the property being validated.}

\item{value}{The value of the property.}

\item{validator}{The expected type or a custom validation function.}
}
\value{
Returns NULL if the validation passes, otherwise returns a character string
        containing an error message describing why the validation failed.
}
\description{
Validates a property to ensure it matches the expected type or satisfies the given validation function.
}
\details{
This function supports various types of validators:
- Enum generators
- Lists of multiple allowed types
- Interface objects
- Built-in R types (character, numeric, logical, integer, double, complex)
- data.table and data.frame types
- Custom validation functions
}
