% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolators.R
\name{iprPCHIP}
\alias{iprPCHIP}
\title{PCHIP interpolator}
\usage{
iprPCHIP(x, y)
}
\arguments{
\item{x, y}{numeric vectors giving the coordinates of the known points,
without missing value}
}
\value{
An interpolator, for usage in \code{\link{evalInterpolator}}.
}
\description{
PCHIP interpolator. It is monotonic.
}
\details{
See \href{https://www.boost.org/doc/libs/1_83_0/libs/math/doc/html/math_toolkit/pchip.html}{PCHIP interpolation}.
}
\examples{
library(interpolators)
x <- seq(0, 4*pi, length.out = 9L)
y <- x - sin(x)
ipr <- iprPCHIP(x, y)
curve(x - sin(x), from = 0, to = 4*pi, lwd = 2)
curve(
  evalInterpolator(ipr, x),
  add = TRUE, col = "blue", lwd = 3, lty = "dashed"
)
points(x, y, pch = 19)
}
