% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{fup_red_PREJAGS}
\alias{fup_red_PREJAGS}
\title{Fup RED Level-4 PREJAGS arguments}
\format{
A named list with 33 elements: \describe{
\item{\code{Test.Nominal.Conc}}{Unique \code{Test.Nominal.Conc} values (expected initial concentration) for the tested compound}
\item{\code{Num.cal}}{Unique number of \code{Calibration} values for the tested compound}
\item{\code{Physiological.Protein.Conc}}{The assumed physiological protein concentration 
for plasma protein binding calculations. (Defaults to 70/(66.5*1000)*1000000.
According to \insertCite{berg2011pathology;textual}{invitroTKstats}: 60-80 mg/mL, albumin is 66.5 kDa,
assume all protein is albumin to estimate default in uM.)}
\item{\code{Assay.Protein.Perecent}}{\code{Percent.Physiologic.Plasma} values for each "Plasma" sample type replicate group}
\item{\code{Num.Plasma.Blank.obs}}{Number of "Plasma.Blank" sample types for the tested compound}
\item{\code{Plasma.Blank.obs}}{\code{Response} of the "Plasma.Blank" sample types for the tested compound}
\item{\code{Plasma.Blank.cal}}{Indices of the unique \code{Calibration} values that corresponds to the "Plasma.Blank" sample types' \code{Calibration} for the tested compound}
\item{\code{Plasma.Blank.df}}{Unique \code{Dilution Factor} of the "Plasma.Blank" sample types for the tested compound}
\item{\code{Plasma.Blank.rep}}{Integer representing "Plasma.Blank" replicate group for the tested compound}
\item{\code{Num.NoPlasma.Blank.obs}}{Number of "NoPlasma.Blank" sample types for the tested compound}
\item{\code{NoPlasma.Blank.obs}}{\code{Response} of the "NoPlasma.Blank" sample types for the tested compound}
\item{\code{NoPlasma.Blank.cal}}{Indices of the unique \code{Calibration} values that corresponds to the "NoPlasma.Blank" sample types' \code{Calibration} for the tested compound}
\item{\code{NoPlasma.Blank.df}}{Unique \code{Dilution Factor} of the "NoPlasma.Blank" sample types for the tested compound}
\item{\code{Num.CC.obs}}{Number of "CC" sample types with non-NA \code{Test.Compound.Conc} values for the tested compound}
\item{\code{CC.conc}}{\code{Test.Compound.Conc} (non-NA) of the "CC" sample types for the tested compound}
\item{\code{CC.obs}}{\code{Response} of the "CC" sample types with non-NA \code{Test.Compound.Conc} for the tested compound}
\item{\code{CC.cal}}{Indices of the unique \code{Calibration} values that corresponds to the "CC" sample types' \code{Calibration} for the tested compound}
\item{\code{CC.df}}{Unique \code{Dilution Factor} of the "NoPlasma.Blank" sample types for the tested compound}
\item{\code{Num.T0.obs}}{Number of "T0" sample types for the tested compound}
\item{\code{T0.obs}}{\code{Response} of the "T0" sample types for the tested compound}
\item{\code{T0.cal}}{Indices of the unique \code{Calibration} values that corresponds to the "T0" sample types' \code{Calibration} for the tested compound}
\item{\code{T0.df}}{Unique \code{Dilution Factor} of the "T0" sample types for the tested compound}
\item{\code{Num.rep}}{Unique number of (\code{Calibration} + \code{Technical.Replicates}) combinations for "PBS" and "Plasma" sample types for the tested compound}
\item{\code{Num.PBS.obs}}{Number of "PBS" sample types for the tested compound}
\item{\code{PBS.obs}}{\code{Response} of the "PBS" sample types for the tested compound}
\item{\code{PBS.cal}}{Indices of the unique \code{Calibration} values that corresponds to the "PBS" sample types' \code{Calibration} for the tested compound}
\item{\code{PBS.df}}{Unique \code{Dilution Factor} of the "PBS" sample types for the tested compound}
\item{\code{PBS.rep}}{Integer representing "PBS" replicate group for the tested compound}
\item{\code{Num.Plasma.obs}}{Number of "Plasma" sample types for the tested compound}
\item{\code{Plasma.obs}}{\code{Response} of the "Plasma" sample types for the tested compound}
\item{\code{Plasma.cal}}{Indices of the unique \code{Calibration} values that corresponds to the "Plasma" sample types' \code{Calibration} for the tested compound}
\item{\code{Plasma.df}}{Unique \code{Dilution Factor} of the "Plasma" sample types for the tested compound}
\item{\code{Plasma.rep}}{Integer representing "Plasma" replicate group for the tested compound}
}
}
\usage{
fup_red_PREJAGS
}
\description{
The arguments given to JAGS for the tested compound during level-4 processing of mass spectrometry measurements of plasma protein binding (PPB) via rapid 
equilibrium dialysis (RED) for per- and poly-fluorinated alkyl substance
(PFAS) samples. Experiments were led by Dr.s Marci Smeltz and Barbara Wetmore 
\insertCite{smeltz2023plasma}{invitroTKstats}. This list is overwritten for each tested
compound. Therefore, only contains arguments given to JAGS for the last tested compound.
}
\references{
\insertRef{waters2008validation}{invitroTKstats}

\insertRef{smeltz2023plasma}{invitroTKstats}
}
\keyword{datasets}
