% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round_output.R
\name{round_output}
\alias{round_output}
\title{Round Numeric Data (Any Level and Assay)}
\usage{
round_output(
  FULL_FILENAME = NULL,
  data.in,
  FILENAME = "MYDATA",
  assay = NULL,
  level = NULL,
  exclusion.cols = NULL,
  sig.figs = 3,
  output.res = FALSE,
  INPUT.DIR = NULL,
  OUTPUT.DIR = NULL,
  verbose = TRUE
)
}
\arguments{
\item{FULL_FILENAME}{(Character) A string used to identify the full filename of
input .tsv or .RData file (i.e. "MYDATA-Clint-Level4.tsv" or "MYDATA-Clint-Level4Analysis-2025-04-23.RData").
The string is also used to name the exported data file (if chosen to be exported). 
(Note: \code{FULL_FILENAME} not required if \code{data.in} is provided.) 
(Defaults to \code{NULL}.)}

\item{data.in}{(Data Frame) Any level data frame generated from \code{invitroTKstats}
package. 
(Note: \code{data.in} not required if \code{FULL_FILENAME} is provided.)}

\item{FILENAME}{(Character) A string used to name the start of the exported 
date file. Only required if input data is a data.frame and output file is being 
exported.
(Defaults to "MYDATA".)}

\item{assay}{(Character) A string used to name the assay used to generate the
input data. The string is appended to the name of the exported data file. Only
required if input data is a data.frame and output file is being exported. 
Must be one of the following assays: "Clint", "Caco-2", "fup-RED", or "fup-UC". 
(Defaults to \code{NULL}.)}

\item{level}{(Character) A string used the name the level of the input data. 
The string is appended to the name of the exported data file. Only required if 
input data is a data.frame and output file is being exported.  
Must be one of the following levels: "0", "1", "2", "3", "4". 
(Defaults to \code{NULL}.)}

\item{exclusion.cols}{(Character) Vector of column names to exclude from rounding. 
(Defaults to \code{NULL}.)}

\item{sig.figs}{(Numeric) The number of significant figures to round the desired 
numeric columns to. 
(Defaults to \code{3}.)}

\item{output.res}{(Logical) When set to \code{TRUE}, the rounded data file will 
be exported to the user's per-session temporary directory as a .tsv (if \code{data.in} is specified
or if \code{FULL_FILENAME} is a .tsv) or as an .RData (if \code{FULL_FILENAME}
is an .RData). 
(Defaults to \code{FALSE}.)}

\item{INPUT.DIR}{(Character) Path to the directory where the \code{FULL_FILENAME} exists. 
If \code{NULL}, looking for the input \code{FULL_FILENAME} in the current working
directory. 
(Defaults to \code{NULL}.)}

\item{OUTPUT.DIR}{(Character) Path to the directory to save the rounded data file. 
If \code{NULL}, the output file will be saved to the user's per-session temporary
directory or \code{INPUT.DIR} if specified. (Defaults to \code{NULL}.)}

\item{verbose}{(\emph{logical}) Indicate whether printed statements should be shown.
(Default is TRUE.)}
}
\value{
A rounded data frame
}
\description{
This function rounds the numeric columns from any level of processing. Numeric
columns may include estimates of chemical-specific toxicokinetic (TK) parameters 
from the relevant \emph{in vitro} assays or numerical data measurements collected 
from the mass spectrometry experiments.
}
\details{
For example, for level-3 or level-4 output results, estimates 
of intrinsic hepatic clearance (Cl~int~) from Hepatocyte Incubation data,
fraction unbound in plasma (F~up~) from Rapid Equilibrium Dialysis (RED) data, 
fraction unbound in plasma (F~up~) from Ultracentrifugation (UC) data, or
apparent membrane permeability from a Caco-2 assay can all be rounded to the 
desired number of significant figures. 

Note: Currently, for level-3 Caco-2 data, the "Frec_A2B.vec" and "Frec_B2A.vec" columns are 
not rounded. However, these columns can be rounded if the level-3 result table 
from \code{\link{calc_caco2_point}} is exported and the number of significant 
figures is specified. 

The input to this function can be any level of data (level-0 through level-4)
corresponding to any assay (Clint, Caco-2, Fup RED, Fup UC). The desired data object 
to be rounded can be a data.frame, specified with \code{data.in}, or a .tsv or 
.RData, specified with \code{FULL_FILENAME}. 

If the rounded output file is chosen to be exported and an output directory is
not specified, it will be exported to the user's R session temporary directory.
This temporary directory is a per-session directory whose path can be found 
with the following code: \code{tempdir()}. For more details, see 
\url{https://www.collinberke.com/til/posts/2023-10-24-temp-directories/}. 

As a best practice, \code{INPUT.DIR} (when importing a .tsv or .RData file) 
and/or \code{OUTPUT.DIR} should be specified to simplify the process of importing
and exporting files. This practice ensures that the exported files can easily 
be found and will not be exported to a temporary directory.
}
\examples{
## Round Clint-L4 data, exclude p-value columns, and don't export results 
level4 <- invitroTKstats::clint_L4
round_output(data.in = level4,
             exclusion.cols = c("Clint.pValue", "Sat.pValue", "degrades.pValue"),
             output.res = FALSE)

## Round Clint-L4 data and export results. 
## Note: Will export as a .tsv file. 
\dontrun{
round_output(data.in = level4, assay = "Clint", level = "4")
}

## Round Clint-L4 .tsv data and export to INPUT.DIR. 
## Will need to replace FULL_FILENAME and INPUT.DIR with full filename and location of .tsv. 
\dontrun{
round_output(FULL_FILENAME = "Example-Clint-Level4.tsv", 
             INPUT.DIR = "<FULL_FILENAME FILE LOCATION>")
}

## Round Clint-L4 .RData and export to OUTPUT.DIR 
## Will need to replace FULL_FILENAME and INPUT.DIR with full filename and location
## of .RData. Will also need to replace OUTPUT.DIR with desired location of rounded 
## data file. 
\dontrun{
round_output(FULL_FILENAME = "Example-Clint-Level4Analysis-2025-04-17.RData",
             INPUT.DIR = "<FULL_FILENAME FILE LOCATION>",
             OUTPUT.DIR = "<DESIRED ROUNDED FILE LOCATION>")
}

}
\author{
Lindsay Knupp
}
