% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_methods_fit_sigma.R
\name{fit_sigma.pk}
\alias{fit_sigma.pk}
\title{Hyperparameter fitting}
\usage{
fit_sigma.pk(obj, preds, pred_col, k = 2, ...)
}
\arguments{
\item{obj}{A [pk] object.}

\item{preds}{A data.frame similar to the results from [predict.pk()] which
contains pre-calculated predictions in addition to the concentration over time
values which can be obtained from [get_data.pk()].}

\item{pred_col}{A character vector with the name of the column with predictions.}

\item{k}{Default 2. The `k` parameter in the log-likelihood formula (see
Details). Must be named if used.}

\item{...}{Additional arguments. Not currently in use.}
}
\value{
The same [pk] object, with new element beginning with `ext_fit`
containing a list of the prediction data used as input and two data.frames with
optimized sigma values and AICs for those predictions per `data_group`.
}
\description{
Fit hyperparameter sigma for a `pk` object with pre-calculated model predictions
}
\details{
This function estimates the hyperparameter \eqn{\sigma} from
a data.frame of pre-calculated model predictions,
using numerical optimization implemented in [optimx::optimx()]. The
optimization is done by maximizing the log-likelihood function implemented in
[log_likelihood()]. Only the non-excluded observations are used.
}
\author{
Gilberto Padilla Mercado
}
