% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_group.R
\name{fit_group}
\alias{fit_group}
\title{Fit a single group of data}
\usage{
fit_group(
  data,
  par_DF,
  sigma_DF,
  fit_decision,
  this_model,
  settings_optimx,
  modelfun,
  dose_norm,
  log10_trans,
  suppress.messages
)
}
\arguments{
\item{data}{A single group of data}

\item{par_DF}{par_DF for a single group of data}

\item{sigma_DF}{sigma_DF for a single group of data}

\item{fit_decision}{Whether the fit is able to be calculated or excluded.}

\item{this_model}{Name of the `pk_model` object to fit}

\item{settings_optimx}{The settings for optimization.}

\item{modelfun}{Name of the model concentration function}

\item{dose_norm}{TRUE or FALSE -- whether to dose-normalize concentrations
before evaluating log-likelihood}

\item{log10_trans}{TRUE or FALSE -- whether to 1og10-transform concentrations
before evaluating log-likelihood}

\item{suppress.messages}{TRUE or FALSE -- whether to suppress messages or emit them}
}
\value{
An object of class `optimx` (i.e. a data.frame with fit results)
}
\description{
Fit a single group of data
}
