% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_params_1comp.R
\name{get_params_1comp}
\alias{get_params_1comp}
\title{Get parameters for 1-compartment model}
\usage{
get_params_1comp(
  data,
  lower_bound = NULL,
  upper_bound = NULL,
  param_units = alist(kelim = paste0("1/", unique(Time_trans.Units)), Vdist = paste0("(",
    unique(Dose.Units), ")/(", unique(Conc.Units), ")"), Fgutabs = "unitless fraction",
    kgutabs = paste0("1/", unique(Time_trans.Units)), Fgutabs_Vdist = paste0("(",
    unique(Conc.Units), ")/(", unique(Dose.Units), ")"), Rblood2plasma =
    "unitless ratio"),
  ...
)
}
\arguments{
\item{data}{The data set to be fitted (e.g. the result of [preprocess_data()])}

\item{lower_bound}{A mapping specified using a call to [alist()],
giving the lower bounds for each variable, as expressions which may include
variables in `data`.}

\item{upper_bound}{A mapping specified using a call to [alist()],
giving the upper bounds for each variable, as expressions which may include
variables in `data`.}

\item{param_units}{A mapping specified using a call to [alist()],
giving the units for each variable, as expressions which may include
variables in `data`.}

\item{...}{Other parameters that can be specified in `pk_model`.}
}
\value{
A `data.frame`with the following variables:
\itemize{
\item `param_name`: Character: Names of the model parameters
\item `param_units`: Character: Units of the model parameters
\item `optimize_param`: TRUE if each parameter is to be estimated from the data; FALSE otherwise
\item `use_param`: TRUE if each parameter is to be used in evaluating the model; FALSE otherwise
\item`lower_bounds`: Numeric: The lower bounds for each parameter
\item `upper_bounds`: Numeric: The upper bounds for each parameter
\item `start`: Numeric: The starting guesses for each parameter
}
}
\description{
Get parameters for 1-compartment model and determine whether each is to be
estimated from the data
}
\details{
The full set of model parameters for the 1-compartment model includes `Vdist`,
`kelim`, `kgutabs`, `Fgutabs`, and `Rblood2plasma`. Whether each one can be
estimated from the data depends on what routes of administration are included
in the data.
}
\section{IV data, no oral data}{


If IV dosing data are available, but no oral dosing data are available, then
only the parameters `Vdist` and `kelim` will be estimated from the data. The
parameters `kgutabs` and `Fgutabs` cannot be estimated from IV data alone, and
will not be used in evaluating the model.
}

\section{Oral data, no IV data}{


If oral dosing data are available, but no IV dosing data are available, then
the parameters `kelim` and `kgutabs` can be estimated from the data. However,
the parameters `Fgutabs` and `Vdist` cannot be identified separately. From
oral data alone, only the ratio `Fgutabs/Vdist` can be identified. This ratio
is represented by a single parameter named `Fgutabs_Vdist`. `Fgutabs` and
`Vdist` will not be used to evaluate the model nor be estimated from data, but
`Fgutabs_Vdist` will be estimated from data, along with `kelim` and `kgutabs`.
}

\section{Oral data and IV data}{


If both oral and IV dosing data are available, then `Vdist`, `kelim`,
`kgutabs`, and `Fgutabs` will all be estimated from the data.
}

\section{Default lower and upper bounds for each parameter}{

\subsection{Default lower and upper bounds for `kelim` and `kgutabs`}{
Default bounds for time constants `kelim` and `kgutabs` are set based on
the time scale of the available data.

The lower bounds are based on the assumption that elimination and absorption
are very slow compared to the time scale of the study. Specifically, the
lower bounds assume that elimination and absorption half-lives are twice as
long as the duration of the available study data, or `2*max(Time_trans)`.
Under this assumption, the corresponding elimination and absorption time
constants would be `log(2)/(2*max(Time_trans))`. Therefore, the default lower
bounds for `kelim` and `kgutabs` are `log(2)/(2*max(Time_trans))`.

Upper bounds are based on the opposite assumption: that elimination and
absorption are very fast compared to the time scale of the study.
Specifically, the upper bounds assume that the elimination and absorption
half-lives are half as long as the time of the first observation after time
0, or `0.5*min(Time_trans[Time_trans>0])`. Under this asumption, the
corresponding elimination and absorption time constants would be
`log(2)/(0.5*min(Time_trans[Time_trans>0]))`. Therefore, the default lower
bounds for `kelim` and `kgutabs` are
`log(2)/(0.5*min(Time_trans[Time_trans>0]))`.
}
\subsection{Default lower and upper bounds for `Vdist`}{
By default, the lower bound for `Vdist` is 0.01, and the upper bound for
`Vdist` is 100. These values were chosen based on professional judgment.
}
\subsection{Default lower and upper bounds for `Fgutabs`}{
By default, the lower bound for `Fgutabs` is 0.0, and the upper bound for
`Fgutabs` is 1. These are simply the bounds of the physically-meaningful
range for a fraction.
}
\subsection{Default lower and upper bounds for `Fgutabs_Vdist`}{
By default, the lower bound for the ratio `Fgutabs_Vdist` is 0.01, and the
upper bound is 100. These values were chosen based on professional judgment.
}
\subsection{Default lower and upper bounds for `Rblood2plasma`}{
By default, the lower bound for the blood:plasma partition coefficient
`Rblood2plasma` is 0.01, and the upper bound is 100. These values were chosen
based on professional judgment.
}
}

\section{Starting values for each parameter}{


Starting values for each parameter (starting guesses for the numerical
optimizer) are derived from the data using [get_starts_1comp()].

If the starting values returned by [get_starts_1comp()] fall outside the
bounds for any parameter(s), then the starting value will be reset to a value
halfway between the lower and upper bounds for that parameter.
}

\section{Blood and plasma data}{


If both blood and plasma data are available, then `Rblood2plasma` will be estimated from the data.
}

\section{Only one of blood or plasma data}{


If only one of blood or plasma data are available, then `Rblood2plasma` will be
held constant at 1, not estimated from the data.
}

\seealso{
Other 1-compartment model functions: 
\code{\link{auc_1comp}()},
\code{\link{cp_1comp}()},
\code{\link{get_starts_1comp}()}

Other get_params functions: 
\code{\link{get_params_2comp}()},
\code{\link{get_params_flat}()}

Other built-in model functions: 
\code{\link{auc_1comp}()},
\code{\link{auc_2comp}()},
\code{\link{auc_flat}()},
\code{\link{auc_httk_gas_pbtk}()},
\code{\link{cp_1comp}()},
\code{\link{cp_2comp}()},
\code{\link{cp_2comp_dt}()},
\code{\link{cp_flat}()},
\code{\link{cp_httk_gas_pbtk}()},
\code{\link{get_params_2comp}()},
\code{\link{get_params_flat}()},
\code{\link{get_params_httk_gas_pbtk}()},
\code{\link{get_starts_1comp}()},
\code{\link{get_starts_2comp}()},
\code{\link{get_starts_flat}()},
\code{\link{get_starts_httk_gas_pbtk}()},
\code{\link{tkstats_2comp}()},
\code{\link{transformed_params_2comp}()}
}
\author{
Caroline Ring
}
\concept{1-compartment model functions}
\concept{built-in model functions}
\concept{get_params functions}
