% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_starts_httk_gas_pbtk.R
\name{get_starts_httk_gas_pbtk}
\alias{get_starts_httk_gas_pbtk}
\title{Get starting values for httk `gas_pbtk` model with specific clearance}
\usage{
get_starts_httk_gas_pbtk(
  data,
  par_DF,
  this_chemical,
  this_species,
  restrictive,
  ...
)
}
\arguments{
\item{data}{The data set to be fitted (e.g. the result of [preprocess_data()])}

\item{par_DF}{A `data.frame` with the following variables
\itemize{
\item `param_name`: Character: Names of the model parameters
\item `param_units`: Character: Units of the model parameters
\item `optimize_param`: TRUE if each parameter is to be estimated from the data; FALSE otherwise
\item `use_param`: TRUE if each parameter is to be used in evaluating the model; FALSE otherwise
\item`lower_bounds`: Numeric: The lower bounds for each parameter
\item `upper_bounds`: Numeric: The upper bounds for each parameter
}}

\item{this_chemical}{A character vector naming the chemical for calculations in `httk`.}

\item{this_species}{A character vector naming the species for calculations in `httk`.}

\item{restrictive}{A boolean value determinining whether to assume restrictive
or non-restrictive clearance when getting starting values.}

\item{...}{Additional parameters, currently only list of character vectors describing
parameters to optimize or parameter start values.}
}
\value{
The same `data.frame` as `par_DF`, with an additional variable
 `starts` containing the derived starting value for each parameter. If a
 parameter cannot be estimated from the available data, then its starting value
 will be `NA_real_`
}
\description{
Derive starting values for PBTK model parameters from available data
}
\details{
This function is called internally by [get_params_httk_gas_pbtk()] and should
generally not be called directly by the user.

The full set of model parameters is given by the \link[httk]{parameterize_3comp2} function in `httk`.

Not all of the parameters are intended to be optimized. Currently, only `Clint`,
`Funbound.plasma`, or any of the model's partitioning coefficients can be optimized.
}
\section{Additional parameters}{

There are also additional parameters calculated to allow recalculation of parameters
during fitting. These include `fabs.oral`, `Fprotein.plasma`, and `Qintestinetrasport`.
}

\seealso{
Other httk model functions: 
\code{\link{auc_httk_gas_pbtk}()},
\code{\link{cp_httk_gas_pbtk}()},
\code{\link{get_params_httk_gas_pbtk}()}

Other get_starts functions: 
\code{\link{get_starts_1comp}()},
\code{\link{get_starts_2comp}()},
\code{\link{get_starts_flat}()}

Other built-in model functions: 
\code{\link{auc_1comp}()},
\code{\link{auc_2comp}()},
\code{\link{auc_flat}()},
\code{\link{auc_httk_gas_pbtk}()},
\code{\link{cp_1comp}()},
\code{\link{cp_2comp}()},
\code{\link{cp_2comp_dt}()},
\code{\link{cp_flat}()},
\code{\link{cp_httk_gas_pbtk}()},
\code{\link{get_params_1comp}()},
\code{\link{get_params_2comp}()},
\code{\link{get_params_flat}()},
\code{\link{get_params_httk_gas_pbtk}()},
\code{\link{get_starts_1comp}()},
\code{\link{get_starts_2comp}()},
\code{\link{get_starts_flat}()},
\code{\link{tkstats_2comp}()},
\code{\link{transformed_params_2comp}()}
}
\author{
Gilberto Padilla Mercado
}
\concept{built-in model functions}
\concept{get_starts functions}
\concept{httk model functions}
