% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equation_solve.R
\name{equation_solve}
\alias{equation_solve}
\title{Solve a basic matrix equation}
\usage{
equation_solve(LHS = NULL, Im = NULL)
}
\arguments{
\item{LHS}{A one-row data frame (or matrix) with a key column first and
numeric columns named to match the Leontief inverse.}

\item{Im}{A Leontief inverse with a key column first and a square numeric
block whose column names match the \code{LHS} numeric names.}
}
\value{
A numeric 1×N matrix containing the solution
\eqn{\text{LHS} \times \text{Im}}.
}
\description{
Match a left-hand side (LHS) vector to a Leontief inverse by column names
and compute the matrix product \eqn{\text{LHS} \times \text{Im}}.
}
\details{
This helper is used by higher-level wrappers such as
\code{\link[=multiplier_create]{multiplier_create()}}. It assumes both inputs have a first key column,
followed by numeric columns whose names define the alignment. The function
multiplies the numeric row of \code{LHS} by the numeric block of \code{Im} after a
basic conformity check.
}
\examples{
Im <- data.frame(
  a = c("row1", "row2"),
  b = c(1, 1),
  c = c(2, 0)
)
LHS <- data.frame(
  a = "lhs",
  b = 1,
  c = 0.5
)
equation_solve(Im = Im, LHS = LHS)

}
