% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consumer.R
\name{Consumer}
\alias{Consumer}
\title{A Class for reading and executing tasks from a source}
\description{
A Class for reading and executing tasks from a source

A Class for reading and executing tasks from a source
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{handlers}}{A list of handlers}

\item{\code{stopped}}{Is currently stopped.}

\item{\code{laterHandle}}{A callback handle.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Consumer-new}{\code{Consumer$new()}}
\item \href{#method-Consumer-setSource}{\code{Consumer$setSource()}}
\item \href{#method-Consumer-getSource}{\code{Consumer$getSource()}}
\item \href{#method-Consumer-consume}{\code{Consumer$consume()}}
\item \href{#method-Consumer-start}{\code{Consumer$start()}}
\item \href{#method-Consumer-stop}{\code{Consumer$stop()}}
\item \href{#method-Consumer-addHandler}{\code{Consumer$addHandler()}}
\item \href{#method-Consumer-clearHandlers}{\code{Consumer$clearHandlers()}}
\item \href{#method-Consumer-removeHandler}{\code{Consumer$removeHandler()}}
\item \href{#method-Consumer-initHandlers}{\code{Consumer$initHandlers()}}
\item \href{#method-Consumer-finalize}{\code{Consumer$finalize()}}
\item \href{#method-Consumer-clone}{\code{Consumer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Consumer-new"></a>}}
\if{latex}{\out{\hypertarget{method-Consumer-new}{}}}
\subsection{Method \code{new()}}{
Creates the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Consumer$new(source)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{A source, e.g. TextFileSource.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Consumer-setSource"></a>}}
\if{latex}{\out{\hypertarget{method-Consumer-setSource}{}}}
\subsection{Method \code{setSource()}}{
Sets the source.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Consumer$setSource(source)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{A source, e.g. TextFileSource.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Consumer-getSource"></a>}}
\if{latex}{\out{\hypertarget{method-Consumer-getSource}{}}}
\subsection{Method \code{getSource()}}{
Gets the source.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Consumer$getSource()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Consumer-consume"></a>}}
\if{latex}{\out{\hypertarget{method-Consumer-consume}{}}}
\subsection{Method \code{consume()}}{
Executes all (unprocessed) signals fired to source from a Producer.
      if \code{throwErrors} is TRUE, the first error encountered is thrown
      after executing all signals. Signals are executed in the \code{env} environment.
      If \code{env} is NULL, the environment set at initialization is used.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Consumer$consume(throwErrors = TRUE, env = parent.frame())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{throwErrors}}{Should errors be thrown or caught.}

\item{\code{env}}{The execution environment.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Consumer-start"></a>}}
\if{latex}{\out{\hypertarget{method-Consumer-start}{}}}
\subsection{Method \code{start()}}{
Starts executing \code{consume} every \code{millis} milliseconds. \code{throwErrors}
      and \code{env} are passed down to \code{consume}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Consumer$start(millis = 250, env = parent.frame())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{millis}}{milliseconds.}

\item{\code{env}}{The execution environment.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Consumer-stop"></a>}}
\if{latex}{\out{\hypertarget{method-Consumer-stop}{}}}
\subsection{Method \code{stop()}}{
Stops the periodic execution of \code{consume}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Consumer$stop()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Consumer-addHandler"></a>}}
\if{latex}{\out{\hypertarget{method-Consumer-addHandler}{}}}
\subsection{Method \code{addHandler()}}{
Adds a handler for 'signal'. func
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Consumer$addHandler(func, signal)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{func}}{The function which takes three parameters: 1. the signal, 2. the message object, and 3. the evaluation environment.}

\item{\code{signal}}{A string to bind the function to.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Consumer-clearHandlers"></a>}}
\if{latex}{\out{\hypertarget{method-Consumer-clearHandlers}{}}}
\subsection{Method \code{clearHandlers()}}{
Removes all handler.s
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Consumer$clearHandlers()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Consumer-removeHandler"></a>}}
\if{latex}{\out{\hypertarget{method-Consumer-removeHandler}{}}}
\subsection{Method \code{removeHandler()}}{
Removes a single handler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Consumer$removeHandler(signal, index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{signal}}{The signal of the handler.}

\item{\code{index}}{The index of the handler to remove from the signal.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Consumer-initHandlers"></a>}}
\if{latex}{\out{\hypertarget{method-Consumer-initHandlers}{}}}
\subsection{Method \code{initHandlers()}}{
Adds default handlers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Consumer$initHandlers()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Consumer-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-Consumer-finalize}{}}}
\subsection{Method \code{finalize()}}{
cleans up object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Consumer$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Consumer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Consumer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Consumer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
