% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ir.R
\name{ir_identify_empty_spectra}
\alias{ir_identify_empty_spectra}
\title{Identifies empty spectra in an \code{ir} object}
\usage{
ir_identify_empty_spectra(x)
}
\arguments{
\item{x}{An object of class \code{ir}.}
}
\value{
A logical vector indicating for each spectrum in \code{x} whether it is
empty (\code{TRUE}) or not (\code{FALSE}).
}
\description{
\code{ir_identify_empty_spectra()} identifies empty spectra in an object of class
\code{\link[=ir_new_ir]{ir}}. An empty spectrum is a spectrum which has no data values
(no rows) or where all intensity values (column \code{y}) are \code{NA}.
}
\examples{
ir_identify_empty_spectra(ir::ir_sample_data)

}
