% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{rename}
\alias{rename}
\alias{rename.ir}
\alias{rename_with.ir}
\title{Rename columns in \code{ir} objects}
\source{
\code{\link[dplyr:rename]{dplyr::rename()}}
}
\usage{
rename.ir(.data, ...)

rename_with.ir(.data, .fn, .cols = dplyr::everything(), ...)
}
\arguments{
\item{.data}{An object of class \code{ir}.}

\item{...}{For \code{rename()}: <\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Use
\code{new_name = old_name} to rename selected variables.

For \code{rename_with()}: additional arguments passed onto \code{.fn}.}

\item{.fn}{A function used to transform the selected \code{.cols}. Should
return a character vector the same length as the input.}

\item{.cols}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Columns to rename;
defaults to all columns.}
}
\value{
\code{.data} with renamed columns. If the \code{spectra} column is renamed,
and no new valid \code{spectra} column is created, the \code{ir} class is dropped, else
the object is of class \code{ir}.
}
\description{
Rename columns in \code{ir} objects
}
\examples{
## rename
dplyr::rename(ir_sample_data, hol = "holocellulose")
dplyr::rename(ir_sample_data, spec = "spectra") # drops ir class


## rename_with
dplyr::rename_with(ir_sample_data, .cols = dplyr::starts_with("id_"),
  toupper)
dplyr::rename_with(ir_sample_data, toupper) # drops ir class


}
\seealso{
Other tidyverse: 
\code{\link{arrange.ir}()},
\code{\link{distinct.ir}()},
\code{\link{extract.ir}()},
\code{\link{filter-joins}},
\code{\link{filter.ir}()},
\code{\link{group_by}},
\code{\link{mutate}},
\code{\link{mutate-joins}},
\code{\link{nest}},
\code{\link{pivot_longer.ir}()},
\code{\link{pivot_wider.ir}()},
\code{\link{rowwise.ir}()},
\code{\link{select.ir}()},
\code{\link{separate.ir}()},
\code{\link{separate_rows.ir}()},
\code{\link{slice}},
\code{\link{summarize}},
\code{\link{unite.ir}()}
}
\concept{tidyverse}
