% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc2x3.r
\name{ci.ICC2a.inter}
\alias{ci.ICC2a.inter}
\title{Confidence Interval of ICCa(2,1), a measure of intra-rater reliability under Model 2 with interaction.}
\usage{
ci.ICC2a.inter(dfra, conflev = 0.95)
}
\arguments{
\item{dfra}{This is a data frame containing 3 columns or more.  The first column contains subject numbers (there could be duplicates
if a subject was assigned multiple ratings) and each of the remaining columns is associated with a particular rater and contains its
numeric ratings.}

\item{conflev}{This is the optional confidence level associated with the confidence interval. If not specified, the default value
will be 0.95, which is the most commonly-used valuee in the literature.}
}
\value{
This function returns a vector containing the lower confidence (lcb) and the upper confidence bound (ucb).
}
\description{
This function computes the confidence interval of the Intraclass Correlation Coefficient ICCa(2,1) under the random factorial ANOVA
model with subject-rater interaction. ICCa(2,1) is formulated as a measure of intra-rater reliability coefficient. This function
computes the lower and upper confidence bounds of the confidence interval.
}
\examples{
#iccdata1 is a small dataset that comes with the package. Use it as follows:
library(irrICC)
iccdata1 #see what the iccdata1 dataset looks like
ci.ICC2a.inter(iccdata1)
ci.ICC2a.inter(iccdata1)$ucb #this only gives the upper confidence bound
ci.ICC2a.inter(iccdata1,0.90) #this gives you the 90\% confidence interval
}
\references{
Gwet, K.L. (2014): \emph{Handbook of Inter-Rater Reliability - 4th ed.} chapter 9, section 9.3.2, equations
9.3.7 and 9.3.8. Advanced Analytics, LLC.
}
