% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc2x3.r
\name{pvals.ICC3r.inter}
\alias{pvals.ICC3r.inter}
\title{P-value of the Intraclass Correlation Coefficient ICC(3,1) under Model 3 with subject-rater interaction.}
\usage{
pvals.ICC3r.inter(dfra, rho.zero = 0)
}
\arguments{
\item{dfra}{This is a data frame containing 3 columns or more.  The first column contains subject numbers (there could be duplicates
if a subject was assigned multiple ratings) and each of the remaining columns is associated with a particular rater and contains its
numeric ratings.}

\item{rho.zero}{This is an optional parameter that represents a vector containing an arbitrary number of null values between 0 and 1
for which a p-value will be calculated. If not specified then its default value will be 0.}
}
\value{
This function returns a vector containing p-values associated with the null values specified in the parameter rho.zero.
}
\description{
This function computes the p-value associated with the ICC under the mixed factorial ANOVA model with subject-rater interaction.
The ICC considered here is the one used as a measure of inter-rater reliability and the p-value is calculated for each of the null
values specified in the parameter rho.zero.
}
\examples{
#iccdata1 is a small dataset that comes with the package. Use it as follows:
library(irrICC)
iccdata1 #see what the iccdata1 dataset looks like
pvals.ICC3r.inter(iccdata1) #gives you the p-value associated with default null value of 0
pvals.ICC3r.inter(iccdata1,c(0,0.15,0.25,0.33)) #produces p-values for an arbitrary vector
}
\references{
Gwet, K.L. (2014): \emph{Handbook of Inter-Rater Reliability - 4th ed.} chapter 10, section 10.3.3 Advanced Analytics, LLC.
}
