% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cat_output.R
\name{plot.cat_output}
\alias{plot.cat_output}
\title{Plot progress of a CAT algorithm for one examinee}
\usage{
\method{plot}{cat_output}(
  x,
  ...,
  plot_b = TRUE,
  se_band = TRUE,
  horizontal_line = "true_theta",
  title = "CAT Progress",
  suppress_plot = FALSE,
  base_r_graph = FALSE
)
}
\arguments{
\item{x}{A "cat_output" object that is output of \code{\link{cat_sim}}
function for one examinee.}

\item{...}{Additional arguments.}

\item{plot_b}{If \code{TRUE}, 'b' parameters of the administered items will
be plotted along with intermediate theta estimates. The default value is
\code{TRUE}.}

\item{se_band}{A logical value. If \code{TRUE}, a standard error band
is added around the estimated theta values. At each stage one standard
error of that stage is added to and subtracted from the ability estimate
at that stage. The default value is \code{TRUE}.}

\item{horizontal_line}{An option to add a horizontal line. Provide either one
of these or a list of a combination of these (except \code{NULL}).
\describe{
  \item{"true_theta"}{Add a horizontal line for true theta.
    Default option.}
  \item{"final_theta"}{Add a horizontal line at final theta
    (ability) estimate}
  \item{NULL}{No horizontal line added.}
}}

\item{title}{Title of the Plot}

\item{suppress_plot}{If \code{FALSE} the function will print the plot. If
\code{TRUE}, function will return the plot object. Default value is
\code{FALSE}.}

\item{base_r_graph}{Currently this function only works with package
  'ggplot2'.

  If \code{TRUE} function will plot graphs using base R
  graphics. If \code{FALSE} the function will check whether 'ggplot2' package
  is installed. If it is installed, it will use 'ggplot2' package for the
  plot. The default value is \code{FALSE}.}
}
\value{
Depending on the value of \code{printPlot} function either prints
the CAT progress plot or returns the plot object.
}
\description{
\code{plot.cat_output} Plots the progress of CAT for one examinee.
}
\examples{
cd <- create_cat_design(ip = generate_ip(n = 100))
co <- cat_sim(true_ability = rnorm(1), cd = cd)

plot(co)

# Suppress item difficulties
plot(co, plot_b = FALSE)

# Suppress Standard Error Band
plot(co, se_band = FALSE)

# Add final theta estimate line
plot(co, horizontal_line = "final_theta")
plot(co, horizontal_line = "true_theta")

# Change Title
plot(co, title = "CAT Progress for Examinee ABC")

\dontrun{
# Change Text Size
plot(co) + theme(text=element_text(size=20))

# Change x-axis label
plot(co) + xlab("My New X Axis Label")

# Change y limits of the graph
plot(co) + coord_cartesian(ylim = c(-5,5))

# Change legend position
plot(co) + theme(legend.position="none")
plot(co) + theme(legend.position="left")

# Add a horizontal line
plot(co) + geom_hline(yintercept = -1, color = "red", linetype = 5)
}
}
\author{
Emre Gonulates
}
