% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso8601type.R
\name{iso8601type}
\alias{iso8601type}
\title{Determine the type of ISO8601 strings}
\usage{
iso8601type(x)
}
\arguments{
\item{x}{character vector with ISO8601 strings}
}
\value{
Character vector with the same length as `x` indicating the type of object
each element in `x` is. Elements of this string are:

\item{Y}{Year.}
\item{M}{Month, or minutes in the time part. When followed by a '.' in the
time part these are fractional minutes.}
\item{D}{Day, this can be dau of the month, day of the week or day of the year.}
\item{T}{Marks the start of the time part.}
\item{H}{Hour. When followed by a '.' these are fractional hours.}
\item{M}{Month.}
\item{S}{Seconds. When followed by a '.' these are fractional seconds.}
\item{Z}{Time is in GMT/Zulu time.}
\item{±Z}{The time zone is indicated using an offset from GMT.}
\item{P}{A period. These are not parsed further.}
\item{I}{An interval. These are not parsed further.}
\item{R}{A repeating interval. These are not parsed further.}
}
\description{
Determine the type of ISO8601 strings
}
\examples{
iso8601type(c("T12", "2045-W05-1T13.5", "2012-12-05", "13:25"))

}
