% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_final_space.R
\name{fit.final_space}
\alias{fit.final_space}
\title{Fit n parameters to observations}
\usage{
fit.final_space(
  workdir,
  obs_file_name,
  sweep_space_digest_folders,
  fit_name = NULL,
  output_dir = NULL,
  delta_reference_box = NaN,
  excluded_boxes = NULL,
  print_correlogram = FALSE,
  print_lda = FALSE,
  print_LS_surfaces = FALSE,
  parameter_subsets = NULL,
  custom_expressions = NULL,
  save_outputs = FALSE,
  export_fit_data = FALSE
)
}
\arguments{
\item{workdir}{Working directory of \strong{\emph{0_ISOBXR_MASTER.xlsx}} master file, \cr
of the dynamic sweep master file (e.g., \strong{\emph{0_EXPLO_DYN_MASTER.xlsx}}) \cr
and where output files will be stored if saved by user. \cr
(character string)}

\item{obs_file_name}{Name of csv file containing observations with csv extension. \cr
Stored in workdir. Example: "observations.csv" \cr
Should contain the following columns: \cr
\enumerate{
\item \strong{BOX_ID}: BOX ID (e.g., A, OCEAN...) as defined in isobxr master file.
\item \strong{delta.def} definition of delta value, e.g., d18O
\item \strong{delta.ref} BOX_ID of reservoir used as a reference.
\item \strong{obs.delta} average observed delta numerical value
\item \strong{obs.CI} confidence interval of delta value
\item \strong{obs.CI.def} definition of confidence interval, e.g., 95% ci
\item \strong{obs.file} name of data source file
}}

\item{sweep_space_digest_folders}{Name of sweep.final_nD digest directory. \cr
Should start with "4_FINnD" and end with "_digest"}

\item{fit_name}{Name given to specific fit. If NULL,
output are named after date and time of fit.}

\item{output_dir}{Destination directory for fit outputs. If NULL, outputs are stored in
sweep_space_digest_folders directory. Default is NULL.}

\item{delta_reference_box}{BOX ID of reference box, used to calculate difference
between any box delta and reference box delta. Default is NaN. \cr
delta_reference_box should match at least one of the values declared
in the delta.ref column of observation csv file.}

\item{excluded_boxes}{list of boxes to exclude from fit. Default is NULL.}

\item{print_correlogram}{If TRUE, includes correlograms to final report when applicable. \cr
Default is FALSE. \cr}

\item{print_lda}{If TRUE, includes linear discriminant analysis to final report
when applicable. \cr
Default is FALSE.}

\item{print_LS_surfaces}{If TRUE, includes surfaces of least squarred residuals
to final report when applicable. \cr
Default is FALSE.}

\item{parameter_subsets}{List of limits vectors for parameters to subset before fit. \cr
For instance: list(swp.A.A_B = c(1, 1.00001))
to subset the swept fractionation factor from box A to B between 1 and 1.00001.}

\item{custom_expressions}{Vector of expressions to add to the list of fitted parameters. \cr
For instance: c("m0.A/f.A_B") to add the ratios of mass of A over A to B flux
to the list of parameters.}

\item{save_outputs}{If TRUE, saves all run outputs to local working directory (workdir). \cr
By default, run outputs are stored in a temporary directory and erased if not saved.
Default is FALSE.}

\item{export_fit_data}{If TRUE, exports fitted data as csv and rds files.}
}
\value{
A observation fit graphical report, in R session or exported as pdf, and a data report as R list or xlsx if required.
}
\description{
A function to find the combinations of values of n parameters
producing final state delta values fitting within confidence intervals of observations.
}
