% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dyn_2D_master.R
\name{read.dyn_2D_master}
\alias{read.dyn_2D_master}
\title{Read and inspect sweep.dyn_2D master files}
\usage{
read.dyn_2D_master(workdir, dyn_2D_master_file, isobxr_master_file)
}
\arguments{
\item{workdir}{Working directory of \strong{\emph{isobxr excel master file}}
and where output files will be stored if exported by user.
(character string)}

\item{dyn_2D_master_file}{Name of \strong{\emph{sweep.dyn_2D excel master file}}.
(without file "xlsx" extension).}

\item{isobxr_master_file}{Name of \strong{\emph{isobxr excel master file}}.
(without file "xlsx" extension).
Default is "0_ISOBXR_MASTER".}
}
\value{
List of formatted dyn_2D_master_file master inputs.
}
\description{
A function to read and inspect the sweep.dyn_2D master files
and obtain a master formatted list.
}
\examples{
read.dyn_2D_master(workdir = "/Users/username/Documents/1_ABC_tutorial",
                   dyn_2D_master_file = "0_SWEEP_DYN_demo",
                   isobxr_master_file = "0_ISOBXR_MASTER")

}
