% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_image.R
\docType{methods}
\name{ternary_image}
\alias{ternary_image}
\alias{ternary_image-method}
\alias{ternary_image,function-method}
\title{Display a Color Image}
\usage{
ternary_image(f, ...)

\S4method{ternary_image}{function}(f, n = 48, palette = NULL, ...)
}
\arguments{
\item{f}{A \code{\link{function}} that takes three arguments (x, y and z coordinates)
and returns a \code{numeric} vector (see \code{\link[=tile_bin]{tile_bin()}}, \code{\link[=tile_density]{tile_density()}},
\code{\link[=tile_interpolate]{tile_interpolate()}}).}

\item{...}{Further parameters to be passed to \code{f}.}

\item{n}{A length-one \code{\link{integer}} vector specifying the maximum number of
tiles on each axis.}

\item{palette}{A \code{\link{function}} that takes a single \code{numeric} vector
(the output of \code{f}) as argument and returns a vector of color.
If \code{NULL}, the default color scheme will be used. If \code{FALSE}, the output
of \code{f} is used as colors.}
}
\value{
\code{ternary_image()} is called it for its side-effects.
}
\description{
Creates a grid of colored triangles with colors corresponding to the output
of a function.
}
\examples{
## RGB
ternary_plot(NULL, xlab = "Red", ylab = "Green", zlab = "Blue")
ternary_image(f = rgb, n = 20, palette = FALSE)
}
\seealso{
Other geometries: 
\code{\link{ternary_arrows}()},
\code{\link{ternary_crosshairs}()},
\code{\link{ternary_labels}()},
\code{\link{ternary_lines}()},
\code{\link{ternary_points}()},
\code{\link{ternary_polygon}()},
\code{\link{ternary_segments}()},
\code{\link{ternary_text}()}
}
\author{
N. Frerebeau
}
\concept{geometries}
