% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itabulate.R
\name{itabulate}
\alias{itabulate}
\title{Iterator that maps a function to a sequence of numeric values}
\usage{
itabulate(f, start = 1, step = 1)
}
\arguments{
\item{f}{the function to apply}

\item{start}{sequence's initial value}

\item{step}{sequence's step size}
}
\value{
an iterator that returns the mapped values from the sequence
}
\description{
Constructs an iterator that maps a given function over an indefinite sequence
of numeric values. The input the function \code{f} is expected to accept a
single numeric argument. The sequence of arguments passed to \code{f} begin
with \code{start} and are incremented by \code{step}.
}
\examples{
it <- itabulate(f=function(x) x + 1)
take(it, 4) # 2 3 4 5

it2 <- itabulate(f=function(x) x^2, start=-3)
take(it2, 6) # 9 4 1 0 1 4

it3 <- itabulate(abs, start=-5, step=2)
take(it3, 6) # 5 3 1 1 3 5

it4 <- itabulate(exp, start=6, step=-2)
take(it4, 4) # exp(c(6, 4, 2, 0))

}
