% Generated by roxygen2 (4.0.1): do not edit by hand
\name{nth}
\alias{nth}
\title{Returns the nth item of an iterator}
\usage{
nth(iterator, n, default = NA)
}
\arguments{
\item{iterator}{an iterator object}

\item{n}{The location of the desired element to return}

\item{default}{The value to return if iterable is consumed, default is NA}
}
\value{
The nth element of the iterable or the default value
}
\description{
Returns the \code{n}th item of an \code{iterator} after advancing the
iterator \code{n} steps ahead. If the \code{iterator} is entirely consumed,
the \code{default} value is returned instead. That is, if either \code{n >
length(iterator)} or \code{n} is 0, then the \code{iterator} is consumed.
}
\examples{
it <- iterators::iter(1:10)
# Returns 5
nth(it, 5)

it2 <- iterators::iter(letters)
# Returns 'e'
nth(it2, 5)

it3 <- iterators::iter(letters)
# Returns default value of NA
nth(it3, 42)

it4 <- iterators::iter(letters)
# Returns default value of "foo"
nth(it4, 42, default="foo")
}

