% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itm.R
\name{itm}
\alias{itm}
\title{Information-Theoretic Measures for Spatial Association}
\usage{
itm(
  formula,
  data,
  method = c("vm", "icm"),
  beta = 1,
  unit = c("e", "2", "10"),
  seed = 42,
  permutation_number = 999
)
}
\arguments{
\item{formula}{A formula.}

\item{data}{A \code{data.frame}, \code{tibble} or \code{sf} object of observation data.}

\item{method}{(optional) whether \code{vm}(default) or \code{icm}.}

\item{beta}{(optional) The \eqn{\beta} value used fo \code{vm} measure, default is \code{1}.}

\item{unit}{(optional) Logarithm base, default is \code{e}.}

\item{seed}{(optional) Random number seed, default is \code{42}.}

\item{permutation_number}{(optional) Number of Random Permutations, default is \code{999}.}
}
\value{
A \code{tibble}.
}
\description{
Information-Theoretic Measures for Spatial Association
}
\examples{
sim = readr::read_csv(system.file('extdata/sim.csv',package = 'itmsa'))
\donttest{
# Information-theoretical V-measure
itm(z1 ~ z2, data = sim, method = 'vm')
# Information Consistency-Based Measures
itm(z1 ~ z2, data = sim, method = 'icm')
}
}
