% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmcc_bioclim.R
\name{cmcc_bioclim}
\alias{cmcc_bioclim}
\title{Download historic Bioclimatic indicators (BIOs) named CMCC-BioClimInd.}
\usage{
cmcc_bioclim(bry = NULL, path = NULL, nm_mark = "clip", return_stack = TRUE)
}
\arguments{
\item{bry}{(\code{\link[sf:sf]{sf}}) The boundary to mask the
downloaded original data. If \code{NULL}, it would get global map.
If not \code{NULL}, it can take \code{\link[sf:sf]{sf}},
\code{\link[sf:sfc]{sfc}}, etc.
The default is \code{NULL}.}

\item{path}{(\code{character}) The path to save the downloaded imagery.
If \code{NULL}, it would use the current working directory.
The default is \code{NULL}.}

\item{nm_mark}{(\code{character}) the name mark of clipped images.
The default is "clip". It would be ignored if \code{bry} is \code{NULL}.}

\item{return_stack}{(\code{logical}) if \code{TRUE}, stack the imagery
together and return.
If the area is large and resolution is high, it is better not to stack them.
The default is \code{TRUE}.}
}
\value{
if \code{return_stack} is \code{TRUE}, the images would be
returned as a \code{stars}. Otherwise, nothing to return, but the user
would receive a message of where the images are.
}
\description{
Parse historic CMCC-BioClimInd bioclimatic indicators
optionally with a setting of boundary and a few other options.
}
\details{
\href{https://doi.pangaea.de/10.1594/PANGAEA.904278?format=html}{Web
page page for this dataset}
}
\note{
The function is experimental at the moment, because the download server
of this dataset is not as stable as Worldclim yet. If it fails due to slow
internet, try to set a larger timeout option,
e.g., using \code{options(timeout = 1e3)}.
}
\examples{
\dontrun{
library(dplyr)
library(sf)
library(itsdm)
bry <- st_polygon(
  list(rbind(c(29.34, -11.72), c(29.34, -0.95),
             c(40.31, -0.95), c(40.31, -11.72),
             c(29.34, -11.72)))) \%>\%
  st_sfc(crs = 4326)

cmcc_bios <- cmcc_bioclim(bry = bry,
  nm_mark = 'tza', path = tempdir())
}

}
\references{
Noce, Sergio, Luca Caporaso, and Monia Santini."A new global dataset of
bioclimatic indicators. "\emph{Scientific data} 7.1 (2020): 1-12.
\doi{10.1038/s41597-020-00726-5}
}
