% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-mixedSort.R
\name{mixedSort}
\alias{mixedSort}
\title{sort alphanumeric values keeping numeric values in proper order}
\usage{
mixedSort(
  x,
  blanksFirst = TRUE,
  na.last = NAlast,
  keepNegative = FALSE,
  keepInfinite = FALSE,
  keepDecimal = FALSE,
  ignore.case = TRUE,
  useCaseTiebreak = TRUE,
  honorFactor = FALSE,
  sortByName = FALSE,
  verbose = FALSE,
  NAlast = TRUE,
  ...
)
}
\arguments{
\item{x}{\code{vector}}

\item{blanksFirst}{\code{logical} whether to order blank entries before entries
containing a value.}

\item{na.last}{\code{logical} indicating whether to move NA entries at
the end of the sort.}

\item{keepNegative}{\code{logical} whether to keep '-' associated with adjacent
numeric values, in order to sort them as negative values.}

\item{keepInfinite}{\code{logical} whether to allow "Inf" to be considered
a numeric infinite value.}

\item{keepDecimal}{\code{logical} whether to keep the decimal in numbers,
sorting as a true number and not as a version number. By default
keepDecimal=FALSE, which means "v1.200" should be ordered before
"v1.30". When keepDecimal=TRUE, the numeric sort considers only
"1.2" and "1.3" and sorts in that order.}

\item{ignore.case}{\code{logical} whether to ignore uppercase and lowercase
characters when defining the sort order. Note that when \code{x} is
\code{factor} the factor levels are converted using
\code{unique(toupper(levels(x)))}, therefore the values in \code{x} will be
sorted by factor level.}

\item{useCaseTiebreak}{\code{logical} indicating whether to break ties
when \code{ignore.case=TRUE}, using mixed case as a tiebreaker.}

\item{honorFactor}{\code{logical}, default TRUE, indicating whether to honor
factor level order in the output, otherwise when FALSE it sorts
as \code{character}.}

\item{sortByName}{\code{logical} whether to sort the vector x by names(x) instead
of sorting by x itself.}

\item{verbose}{\code{logical} whether to print verbose output.}

\item{NAlast}{\code{logical} deprecated in favor of argument \code{na.last}
for consistency with \code{base::sort()}.}

\item{...}{additional parameters are sent to \code{\link{mixedOrder}}.}
}
\value{
\code{vector} of values from argument \code{x}, ordered by
\code{mixedOrder()}. The output class should match \code{class(x)}.
}
\description{
sort alphanumeric values keeping numeric values in proper order
}
\details{
This function is a refactor of \code{gtools} mixedsort(), a clever bit of
R coding from the \code{gtools} package. It was extended to make it slightly
faster, and to handle special cases slightly differently.
It was driven by the need to sort gene symbols, miRNA symbols, chromosome
names, all with proper numeric order, for example:

\describe{
\item{test set:}{miR-12,miR-1,miR-122,miR-1b,mir-1a}
\item{gtools::mixedsort:}{miR-122,miR-12,miR-1,miR-1a,mir-1b}
\item{mixedSort:}{miR-1,miR-1a,miR-1b,miR-12,miR-122}
}

The function does not by default recognize negative numbers as negative,
instead it treats '-' as a delimiter, unless \code{keepNegative=TRUE}.

This function also attempts to maintain '.' as part of a decimal number,
which can be problematic when sorting IP addresses, for example.

This function is really just a wrapper function for \code{mixedOrder()},
which does the work of defining the appropriate order.

The sort logic is roughly as follows:
\itemize{
\item Split each term into alternating chunks containing \code{character}
or \code{numeric} substrings, split across columns in a matrix.
\item Apply appropriate \code{ignore.case} logic to the character substrings,
effectively applying \code{toupper()} on substrings
\item Define rank order of character substrings in each matrix column,
maintaining ties to be resolved in subsequent columns.
\item Convert \code{character} to \code{numeric} ranks via \code{factor} intermediate,
defined higher than the highest \code{numeric} substring value.
\item When \code{ignore.case=TRUE} and \code{useCaseTiebreak=TRUE}, an additional
tiebreaker column is defined using the \code{character} substring values
without applying \code{toupper()}.
\item A final tiebreaker column is the input string itself, with \code{toupper()}
applied when \code{ignore.case=TRUE}.
\item Apply order across all substring columns.
}

Therefore, some expected behaviors:
\itemize{
\item When \code{ignore.case=TRUE} and \code{useCaseTiebreak=TRUE} (default for both)
the input data is ordered without regard to case, then the tiebreaker
applies case-specific sort criteria to the final product. This logic
is very close to default \code{sort()} except for the handling of internal
\code{numeric} values inside each string.
}
}
\examples{
x <- c("miR-12","miR-1","miR-122","miR-1b", "miR-1a", "miR-2");
sort(x);
mixedSort(x);

# test honorFactor
mixedSort(factor(c("Cnot9", "Cnot8", "Cnot10")))
mixedSort(factor(c("Cnot9", "Cnot8", "Cnot10")), honorFactor=TRUE)

# test ignore.case
mixedSort(factor(c("Cnot9", "Cnot8", "CNOT9", "Cnot10")))
mixedSort(factor(c("CNOT9", "Cnot8", "Cnot9", "Cnot10")))
mixedSort(factor(c("Cnot9", "Cnot8", "CNOT9", "Cnot10")), ignore.case=FALSE)
mixedSort(factor(c("Cnot9", "Cnot8", "CNOT9", "Cnot10")), ignore.case=TRUE)

mixedSort(factor(c("Cnot9", "Cnot8", "CNOT9", "Cnot10")), useCaseTiebreak=TRUE)
mixedSort(factor(c("CNOT9", "Cnot8", "Cnot9", "Cnot10")), useCaseTiebreak=FALSE)

}
\seealso{
Other jam sort functions: 
\code{\link{mixedOrder}()},
\code{\link{mixedSortDF}()},
\code{\link{mixedSorts}()},
\code{\link{mmixedOrder}()}
}
\concept{jam sort functions}
