% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{relist_named}
\alias{relist_named}
\title{relist a vector which allows re-ordered names}
\usage{
relist_named(x, skeleton, ...)
}
\arguments{
\item{x}{vector to be applied to the \code{skeleton} list
structure in order.}

\item{skeleton}{\code{list} object representing the desired
final list structure, or \code{vector} when the input
data \code{x} should be returned as-is, without change.
Specifically, when \code{skeleton} is a \code{vector}, the
\code{names(x)} are maintained without change.}

\item{...}{additional arguments are ignored.}
}
\value{
\code{list} object with the same structure as the \code{skeleton}.
}
\description{
relist a vector which imposes the model object list structure while
allowing vector elements and names to be re-ordered
}
\details{
This function is a simple update to \code{utils::relist()}
that allows the order of vectors to change, alongside the
correct names for each element.

More specifically, this function does not replace the
updated names with the corresponding names from
the list \code{skeleton}, as is the case in default implementation of
\code{utils::relist()}.

This function is called by \code{mixedSorts()} which iteratively calls
\code{mixedOrder()} on each vector component of the input \code{list},
and permits nested lists. The result is a single sorted vector
which is split into the \code{list} components, then relist-ed to
the original structure. During the process, it is important
to retain vector names in the order defined by \code{mixedOrder()}.
}
\examples{
# generate nested list
x <- list(A=nameVector(LETTERS[3:1]),
   B=list(
      E=nameVector(LETTERS[10:7]),
      D=nameVector(LETTERS[5:4])),
   C=list(
      G=nameVector(LETTERS[19:16]),
      F=nameVector(LETTERS[15:11]),
      H=list(
         I=nameVector(LETTERS[22:20]))
      ))
x

# unlisted vector of items
xu <- unlist(unname(x))
# unlisted vector of names
xun <- unname(jam_rapply(x, names));
names(xu) <- xun;

# recursive list element lengths
xrn <- jam_rapply(x, length);
# define factor in order of list structure
xn <- factor(
   rep(names(xrn),
      xrn),
   levels=names(xrn));

# re-create the original list
xu_new <- unlist(unname(split(xu, xn)))
xnew <- relist_named(xu_new, x);
xnew

# re-order elements
k <- mixedOrder(xu_new);
xuk <- unlist(unname(split(xu[k], xn[k])))
xk <- relist_named(xuk, x);
xk

# the default relist() function does not support this use case
xdefault <- relist(xuk, x);
xdefault

}
\seealso{
Other jam list functions: 
\code{\link{cPaste}()},
\code{\link{heads}()},
\code{\link{jam_rapply}()},
\code{\link{list2df}()},
\code{\link{mergeAllXY}()},
\code{\link{mixedSorts}()},
\code{\link{rbindList}()},
\code{\link{rlengths}()},
\code{\link{sclass}()},
\code{\link{sdim}()},
\code{\link{uniques}()},
\code{\link{unnestList}()}
}
\concept{jam list functions}
