% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/janus.R, R/main.R
\docType{package}
\name{janus}
\alias{janus}
\alias{janus-package}
\title{janus}
\usage{
janus(
  data,
  rating_label,
  rater_label,
  rated_label,
  task,
  skip_shortcut = FALSE,
  rater_embedding_size = c(8, 32),
  rated_embedding_size = c(8, 32),
  layers = c(1, 5),
  activations = c("elu", "selu", "relu", "sigmoid", "softmax", "softplus", "softsign",
    "tanh", "linear", "leaky_relu", "parametric_relu", "thresholded_relu", "swish",
    "gelu", "mish", "bent"),
  nodes = c(8, 512),
  regularization_L1 = c(0, 100),
  regularization_L2 = c(0, 100),
  dropout = c(0, 1),
  batch_size = 64,
  epochs = 10,
  optimizer = c("adam", "sgd", "adamax", "adadelta", "adagrad", "nadam", "rmsprop"),
  opt_metric = "bac",
  folds = 3,
  reps = 1,
  holdout = 0.1,
  n_steps = 3,
  n_samp = 10,
  offset = 0,
  n_top = 3,
  seed = 999,
  verbose = TRUE
)
}
\arguments{
\item{data}{A data frame including at least three features: rating actor, rated item and rating value.}

\item{rating_label}{String. Single label for the feature containing the rating values.}

\item{rater_label}{String. Single label for the feature containing the rating actors.}

\item{rated_label}{String. Single label for the feature containing the rated items.}

\item{task}{String. Available options are: "regr", for regression (when the rating value is numeric); "classif", for classification (when the rating value is a class or a factor).}

\item{skip_shortcut}{Logical. Option to add a skip shortcut to improve network performance in case of many layers. Default: FALSE.}

\item{rater_embedding_size}{Integer. Output dimension for embedding the rating actors. Default: coarse-to-fine search (8 to 32).}

\item{rated_embedding_size}{Integer. Output dimension for embedding the rated items. Default: coarse-to-fine search (8 to 32).}

\item{layers}{Positive integer. Number of layers for DNN. Default: coarse-to-fine search (1 to 5).}

\item{activations}{String. String vector with the activation functions for each layer. Default: coarse-to-fine search ("elu", "selu", "relu", "sigmoid", "softmax", "softplus", "softsign", "tanh", "linear", "leaky_relu", "parametric_relu", "thresholded_relu", "swish", "gelu", "mish", "bent").}

\item{nodes}{Positive integer. Integer vector with nodes for each layer. Default: coarse-to-fine search (8 to 512).}

\item{regularization_L1}{Positive numeric. Value for L1 regularization of loss function. Default: coarse-to-fine search (0 to 100).}

\item{regularization_L2}{Positive numeric. Value for L2 regularization of loss function. Default: coarse-to-fine search (0 to 100).}

\item{dropout}{Positive numeric. Value for dropout parameter at each layer (bounded between 0 and 1). Default: coarse-to-fine search (0 to 1).}

\item{batch_size}{Positive integer. Maximum batch size for training. Default: 64.}

\item{epochs}{Positive integer. Maximum number of forward and backward propagation. Default: 10.}

\item{optimizer}{String. Standard Tensorflow/Keras Optimization methods are available. Default: coarse-to-fine search ("adam", "sgd", "adamax", "adadelta", "adagrad", "nadam", "rmsprop").}

\item{opt_metric}{String. Error metric to track for the coarse-to-fine optimization. Different options: for regression, "rmse", "mae", "mdae", "mape", "smape", "rae", "rrse"; for classification, "bac", "avs", "avp", "avf", "kend", "ndcg".}

\item{folds}{Positive integer. Number of folds for repeated cross-validation. Default: 3.}

\item{reps}{Positive integer. Number of repetitions for repeated cross-validation. Default: 1.}

\item{holdout}{Positive numeric. Percentage of cases for holdout validation. Default: 0.1.}

\item{n_steps}{Positive integer. Number of phases for the coarse-to-fine optimization process (minimum 2). Default: 3.}

\item{n_samp}{Positive integer. Number of sampled models per coarse-to-fine phase. Default: 10.}

\item{offset}{Positive numeric. Percentage of expansion of numeric boundaries during the coarse-to-fine optimization. Default: 0.}

\item{n_top}{Positive integer. Number of candidates selected during the coarse-to-fine phase. Default: 3.}

\item{seed}{Positive integer. Seed value to control random processes. Default: 42.}

\item{verbose}{Printing specific messages. Default: TRUE.}
}
\value{
This function returns a list including:
\itemize{
\item pipeline:
\item model:
\itemize{
\item configuration: DNN hyper-parameters (layers, activations, regularization_L1, regularization_L2, nodes, dropout)
\item model: Keras standard model description
\item recommend: function to use to recommend on rating actors
\item plot: Keras standard history plot
\item training_metrics: tracking of opt_metric across folds and repetitions
\item test_frame: testing set with the related predictions, including
\item testing_metrics: summary statistics for testing
}
\item time_log
}
}
\description{
Coarse-to-fine optimization of a recommending system based on deep neural networks with Tensorflow/Keras back-end
}
\seealso{
Useful links:
\itemize{
  \item \url{https://rpubs.com/giancarlo_vercellino/janus}
}

}
\author{
\strong{Maintainer}: Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com} [copyright holder]


Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}
}
