% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-jipApprox.R
\docType{package}
\name{jipApprox-package}
\alias{jipApprox}
\alias{jipApprox-package}
\title{jipApprox: Approximate inclusion probabilities for survey sampling}
\description{
Approximate joint-inclusion probabilities in Unequal Probability Sampling,
or compute Monte Carlo approximations of the first and second-order inclusion
probabilities of a general sampling design as in Fattorini (2006)
<doi:10.1093/biomet/93.2.269>.
}
\section{Approximation of Joint-inclusion probabilities}{

Function \code{\link{jip_approx}} provides a number of approximations of the
second-order inclusion probabilities that require only the first-order inclusion
probabilities. These approximations may be employed in unequal probability sampling
design with high entropy. A more flexible approximation may be obtained by using
function \code{\link{jip_MonteCarlo}}, which estimates inclusion probabilities
through a Monte Carlo simulation.

The variance of the Horvitz-Thompson total estimator may be then estimated by
plugging the approximated joint probabilities into the Horvitz-Thompson or
Sen-Yates-Grundy variance estimator using function \code{\link{HTvar}}.
}

\references{
Matei, A.; Tillé, Y., 2005. Evaluation of variance approximations and estimators
in maximum entropy sampling with unequal probability and fixed sample size.
Journal of Official Statistics 21 (4), 543-570.

Haziza, D.; Mecatti, F.; Rao, J.N.K. 2008.
Evaluation of some approximate variance estimators under the Rao-Sampford
unequal probability sampling design. Metron LXVI (1), 91-108.

Fattorini, L. 2006.
Applying the Horvitz-Thompson criterion in complex designs: A computer-intensive
perspective for estimating inclusion probabilities.
Biometrika 93 (2), 269-278
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/rhobis/jipApprox/issues}
}

}
\author{
\strong{Maintainer}: Roberto Sichera \email{rob.sichera@gmail.com}

}
