% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{plot_cisurvfitJMCS}
\alias{plot_cisurvfitJMCS}
\title{Plot for \code{cisurvfitJMCS} object}
\usage{
plot_cisurvfitJMCS(object)
}
\arguments{
\item{object}{fitted \code{survfitJMCS} object}
}
\value{
Plot for predicted survival probability
}
\description{
prediction of survival probability and longitudinal marker using \code{FastJM} for BIG data
}
\examples{
  \donttest{
##
library(survival)
library(dplyr)
jmcs1<-jmcsBig(dtlong=data.frame(long2),
dtsurv = data.frame(surv2),
longm=y~ x7+visit,
survm=Surv(time,status)~x1+visit,
rd= ~ visit|id,
samplesize=200,id='id')
mod2<-jmcs1
P2<-survfitJMCS(model<-mod2,ids<-c(5),u<-seq(surv2[surv2$id==5,]$time,
surv2[surv2$id==5,]$time+10,0.2),obs.time='time')
P3<-cisurvfitJMCS(P2)
plot_cisurvfitJMCS(P3)
##
  }
}
