% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advanced_patterns.R
\name{analyze_join_chain}
\alias{analyze_join_chain}
\title{Analyze Multi-Table Join Chain}
\usage{
analyze_join_chain(tables, joins)
}
\arguments{
\item{tables}{A named list of data frames to join.}

\item{joins}{A list of join specifications, each with elements:
\describe{
\item{left}{Name of left table}
\item{right}{Name of right table}
\item{by}{Join column(s)}
}}
}
\value{
A summary of the join chain analysis.
}
\description{
Analyzes a sequence of joins to identify potential issues in the chain.
Useful for debugging complex multi-table joins.
}
\examples{
orders <- data.frame(order_id = 1:3, customer_id = c(1, 2, 2))
customers <- data.frame(customer_id = 1:3, region_id = c(1, 1, 2))
regions <- data.frame(region_id = 1:2, name = c("North", "South"))

analyze_join_chain(
  tables = list(orders = orders, customers = customers, regions = regions),
  joins = list(
    list(left = "orders", right = "customers", by = "customer_id"),
    list(left = "result", right = "regions", by = "region_id")
  )
)

}
\seealso{
\code{\link[=join_spy]{join_spy()}}, \code{\link[=check_cartesian]{check_cartesian()}}
}
