% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Pois.R
\name{Pois}
\alias{Pois}
\alias{d,Pois,numeric-method}
\alias{p,Pois,numeric-method}
\alias{qn,Pois,numeric-method}
\alias{r,Pois,numeric-method}
\alias{mean,Pois-method}
\alias{median,Pois-method}
\alias{mode,Pois-method}
\alias{var,Pois-method}
\alias{sd,Pois-method}
\alias{skew,Pois-method}
\alias{kurt,Pois-method}
\alias{entro,Pois-method}
\alias{finf,Pois-method}
\alias{llpois}
\alias{ll,Pois,numeric-method}
\alias{epois}
\alias{mle,Pois,numeric-method}
\alias{me,Pois,numeric-method}
\alias{vpois}
\alias{avar_mle,Pois-method}
\alias{avar_me,Pois-method}
\title{Poisson Distribution}
\usage{
Pois(lambda = 1)

\S4method{d}{Pois,numeric}(distr, x, log = FALSE)

\S4method{p}{Pois,numeric}(distr, q, lower.tail = TRUE, log.p = FALSE)

\S4method{qn}{Pois,numeric}(distr, p, lower.tail = TRUE, log.p = FALSE)

\S4method{r}{Pois,numeric}(distr, n)

\S4method{mean}{Pois}(x)

\S4method{median}{Pois}(x)

\S4method{mode}{Pois}(x)

\S4method{var}{Pois}(x)

\S4method{sd}{Pois}(x)

\S4method{skew}{Pois}(x)

\S4method{kurt}{Pois}(x)

\S4method{entro}{Pois}(x)

\S4method{finf}{Pois}(x)

llpois(x, lambda)

\S4method{ll}{Pois,numeric}(distr, x)

epois(x, type = "mle", ...)

\S4method{mle}{Pois,numeric}(distr, x, na.rm = FALSE)

\S4method{me}{Pois,numeric}(distr, x, na.rm = FALSE)

vpois(lambda, type = "mle")

\S4method{avar_mle}{Pois}(distr)

\S4method{avar_me}{Pois}(distr)
}
\arguments{
\item{lambda}{numeric. The distribution parameter.}

\item{distr}{an object of class \code{Pois}.}

\item{x}{For the density function, \code{x} is a numeric vector of quantiles. For
the moments functions, \code{x} is an object of class \code{Pois}. For the
log-likelihood and the estimation functions, \code{x} is the sample of
observations.}

\item{log, log.p}{logical. Should the logarithm of the probability be
returned?}

\item{q}{numeric. Vector of quantiles.}

\item{lower.tail}{logical. If TRUE (default), probabilities are
\eqn{P(X \leq x)}, otherwise \eqn{P(X > x)}.}

\item{p}{numeric. Vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}

\item{type}{character, case ignored. The estimator type (mle or me).}

\item{...}{extra arguments.}

\item{na.rm}{logical. Should the \code{NA} values be removed?}
}
\value{
Each type of function returns a different type of object:
\itemize{
\item Distribution Functions: When supplied with one argument (\code{distr}), the
\code{d()}, \code{p()}, \code{q()}, \code{r()}, \code{ll()} functions return the density, cumulative
probability, quantile, random sample generator, and log-likelihood functions,
respectively. When supplied with both arguments (\code{distr} and \code{x}), they
evaluate the aforementioned functions directly.
\item Moments: Returns a numeric, either vector or matrix depending on the moment
and the distribution. The \code{moments()} function returns a list with all the
available methods.
\item Estimation: Returns a list, the estimators of the unknown parameters. Note
that in distribution families like the binomial, multinomial, and negative
binomial, the size is not returned, since it is considered known.
\item Variance: Returns a named matrix. The asymptotic covariance matrix of the
estimator.
}
}
\description{
The Poisson distribution is a discrete probability distribution that models
the number of events occurring in a fixed interval of time or space, given
that the events occur with a constant rate \eqn{\lambda > 0} and
independently of the time since the last event.
}
\details{
The probability mass function (PMF) of the Poisson distribution is:
\deqn{ P(X = k) = \frac{\lambda^k e^{-\lambda}}{k!}, \quad k \in
\mathbb{N}_0. }
}
\examples{
# -----------------------------------------------------
# Pois Distribution Example
# -----------------------------------------------------

# Create the distribution
lambda <- 5
D <- Pois(lambda)

# ------------------
# dpqr Functions
# ------------------

d(D, 0:10) # density function
p(D, 0:10) # distribution function
qn(D, c(0.4, 0.8)) # inverse distribution function
x <- r(D, 100) # random generator function

# alternative way to use the function
df <- d(D) ; df(x) # df is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
median(D) # Median
mode(D) # Mode
var(D) # Variance
sd(D) # Standard Deviation
skew(D) # Skewness
kurt(D) # Excess Kurtosis
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

ll(D, x)
llpois(x, lambda)

epois(x, type = "mle")
epois(x, type = "me")

mle(D, x)
me(D, x)
e(D, x, type = "mle")

mle("pois", x) # the distr argument can be a character

# ------------------
# Estimator Variance
# ------------------

vpois(lambda, type = "mle")
vpois(lambda, type = "me")

avar_mle(D)
avar_me(D)

v(D, type = "mle")
}
\seealso{
Functions from the \code{stats} package: \code{\link[=dpois]{dpois()}}, \code{\link[=ppois]{ppois()}}, \code{\link[=qpois]{qpois()}},
\code{\link[=rpois]{rpois()}}
}
