% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_tests.R
\name{tests}
\alias{tests}
\alias{test_consistency}
\alias{test_avar}
\title{Estimation and Variance Tests}
\usage{
test_consistency(est, D0, n = 10000, seed = 1, ...)

test_avar(est, D0, n = 10000, m = 1000, seed = 1, bar = FALSE, ...)
}
\arguments{
\item{est}{character. The estimator to be tested.}

\item{D0}{An object of class \code{Distribution}.}

\item{n}{integer. The sample size to be simulated.}

\item{seed}{integer. Passed to \code{set.seed()}.}

\item{...}{extra arguments passed to the estimator.}

\item{m}{integer. The number of samples to be simulated.}

\item{bar}{logical. Should a progress bar be printed?}
}
\value{
A list with the simulation and the expected results so that they
can be compared in tests.
}
\description{
This set of functions employs Monte Carlo simulations to check the
consistency of the estimators (i.e. that the estimators are coded correctly)
and their asymptotic normality (i.e. that their asymptotic variance is
coded correctly).
}
\examples{
\dontrun{
D <- Beta(2, 3)
test1 <- test_consistency("me", D)
test2 <- test_avar("mle", D)
}
}
\keyword{internal}
