% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spray.R
\name{spray}
\alias{spray}
\title{Spray: Disaggregates population counts by dividing the admin total by the number of grid cells within the
administrative units. Then admin proportions are used to further disaggregate the grid cell totals by groups}
\usage{
spray(df, rdf, rclass, output_dir, verbose = TRUE)
}
\arguments{
\item{df}{A data frame object containing sample data (often partially observed) on different demographic groups population. It contains the admin's
total populatioin count to be disaggregated as well as other key variables as defined within the 'toydata'.}

\item{rdf}{A gridded data frame object containing key information on the grid cells. Variables include the admin_id which must be identical to the one
in the admin level data. It contains GPS coordinates. i.e, longitude (lon) and Latitude (lat) of the grid cell's centroids.}

\item{rclass}{This is a user-defined names of the files to be saved in the output folder.}

\item{output_dir}{This is the directory with the name of the output folder where the
disaggregated population proportions and population totals are
automatically saved.}

\item{verbose}{Logical. If TRUE, prints progress messages. Default is TRUE.}
}
\value{
A list of data frame objects of the output files including the disaggregated population proportions and population totals
along with the corresponding measures of uncertainties (lower and upper bounds of 95-percent credible intervals) for each demographic characteristic.
In addition, a file containing the model performance/model fit evaluation metrics is also produced.
}
\description{
This function disaggregates population estimates at grid cell levels when there are no information on the building and population counts.
}
\examples{
\donttest{
if (requireNamespace("INLA", quietly = TRUE)) {
 # load relevant libraries
 library(raster)
 library(terra)
 # load toy data
 data(toydata)
 # run 'cheesepop' function for admin level disaggregation
 result <- cheesepop(df = toydata$admin,output_dir = tempdir())
 rclass <- paste0("TOY_population_v1_0_age",1:12) # Mean
 # run 'spray' for grid cell level disaggregation
 result2 <- spray(df = result$full_data, rdf = toydata$grid, rclass, output_dir = tempdir())
 ras2<- rast(paste0(output_dir = tempdir(), "/pop_TOY_population_v1_0_age4.tif"))
 plot(ras2) # visualize
}
}

}
