% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_mesh.R
\name{meshcode_sf}
\alias{meshcode_sf}
\title{Conversion to sf objects containing meshcode}
\usage{
meshcode_sf(data, mesh_var, .type, .keep_class = FALSE)
}
\arguments{
\item{data}{data.frame}

\item{mesh_var}{unquoted expressions for meshcode variable.}

\item{.type}{Specify the \code{subdivision} if you want to get a 100m mesh.}

\item{.keep_class}{Do you want to assign a class to the meshcode column
in data.frame? If \code{FALSE}, it will be treated as a character type.}
}
\value{
\link[sf:sf]{sf} object
}
\description{
Convert and export meshcode area to \code{sf}.
}
\examples{
d <- data.frame(id = seq.int(4),
            meshcode = rmesh(4),
            stringsAsFactors = FALSE)
meshcode_sf(d, meshcode)
}
