% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrSiCKLSNMF.R
\name{BuildSNNGraphLaplacians}
\alias{BuildSNNGraphLaplacians}
\title{Build SNN graphs and generate their graph Laplacians}
\usage{
BuildSNNGraphLaplacians(SickleJr, k = 20)
}
\arguments{
\item{SickleJr}{An object of class SickleJr}

\item{k}{Number of KNN neighbors to calculate SNN graph; defaults to 20}
}
\value{
An object of class SickleJr with list of graph Laplacians in sparse
matrix format added to its \code{graph.laplacian.list} slot
}
\description{
Generate graph Laplacians for graph regularization of
jrSiCKLSNMF from the list of raw count matrices using an SNN graph. SNN is more robust to
situations where the number of cells outnumbers the number of features. Uses
the \code{scran} package's \code{BuildSNNGraph} function \insertCite{Lun2016}{jrSiCKLSNMF}
}
\examples{
SimSickleJrSmall<-BuildSNNGraphLaplacians(SimSickleJrSmall)
}
\references{
\insertRef{Lun2016}{jrSiCKLSNMF}
}
